/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.commands;

import java.util.Map;
import net.kyori.adventure.text.Component;
import net.lunark.io.database.DatabaseManager;
import net.lunark.io.language.LanguageManager;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public class DatabaseCommand
implements CommandExecutor {
    private final DatabaseManager databaseManager;
    private final LanguageManager languageManager;

    public DatabaseCommand(DatabaseManager databaseManager, LanguageManager languageManager) {
        this.databaseManager = databaseManager;
        this.languageManager = languageManager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Map<String, DatabaseManager.DatabaseStatus> statusMap = this.databaseManager.getAllStatus();
        Component header = this.languageManager.getComponent("database.header", "<dark_aqua>\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2557", new LanguageManager.ComponentPlaceholder[0]);
        Component title = this.languageManager.getComponent("database.title", "<dark_aqua>\u2551  <bold>Database Status</bold>                     \u2551", new LanguageManager.ComponentPlaceholder[0]);
        Component separator = this.languageManager.getComponent("database.separator", "<dark_aqua>\u2560\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2563", new LanguageManager.ComponentPlaceholder[0]);
        sender.sendMessage(header);
        sender.sendMessage(title);
        sender.sendMessage(separator);
        if (statusMap.isEmpty()) {
            Component none = this.languageManager.getComponent("database.none", "<red>No databases configured!", new LanguageManager.ComponentPlaceholder[0]);
            sender.sendMessage(none);
        } else {
            statusMap.forEach((key, status) -> {
                String statusColor = status.connected() ? "<#32E800>" : "<#FF0000>";
                String enabledText = status.connected() ? "CONNECTED" : "ERROR";
                String message = status.connected() ? "OK" : status.message();
                Component entry = this.languageManager.getComponent("database.entry", "<dark_aqua>\u2551  <yellow>{name}</yellow> - {status}{msg} <gray>({enabled})</gray>  \u2551", LanguageManager.ComponentPlaceholder.of("{name}", key), LanguageManager.ComponentPlaceholder.of("{status}", statusColor), LanguageManager.ComponentPlaceholder.of("{msg}", message), LanguageManager.ComponentPlaceholder.of("{enabled}", enabledText));
                sender.sendMessage(entry);
            });
            if (args.length > 0 && args[0].equalsIgnoreCase("kits")) {
                this.showKitStats(sender);
            }
        }
        Component footer = this.languageManager.getComponent("database.footer", "<dark_aqua>\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d", new LanguageManager.ComponentPlaceholder[0]);
        sender.sendMessage(footer);
        return true;
    }

    private void showKitStats(CommandSender sender) {
        Component kitTitle = this.languageManager.getComponent("database.kit-stats", "<gold>Kit Database Stats:</gold> <gray>Table: kit_claims</gray>", new LanguageManager.ComponentPlaceholder[0]);
        sender.sendMessage(kitTitle);
    }
}

