/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.commands.config;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.plugin.Plugin;

public final class HatConfig {
    private final Set<Material> allowedItems;
    private final boolean requireAllowedList;

    public HatConfig(Plugin plugin) {
        boolean requireAllowedList1 = plugin.getConfig().getBoolean("hat.require-allowed-list", false);
        List itemList = plugin.getConfig().getStringList("hat.allowed-items");
        this.allowedItems = new HashSet<Material>();
        for (String itemName : itemList) {
            try {
                Material mat = Material.valueOf((String)itemName.toUpperCase());
                this.allowedItems.add(mat);
            }
            catch (IllegalArgumentException e) {
                plugin.getLogger().warning("Invalid material in hat.allowed-items: " + itemName);
            }
        }
        if (this.allowedItems.isEmpty()) {
            requireAllowedList1 = false;
        }
        this.requireAllowedList = requireAllowedList1;
    }

    public boolean isAllowedItem(Material material) {
        return !this.requireAllowedList || this.allowedItems.contains(material);
    }
}

