/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.commands.config;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public final class SellConfig {
    private final Plugin plugin;
    private final Map<Material, Double> sellPrices = new HashMap<Material, Double>();
    public final String guiTitle;
    public final int guiSize;
    public final boolean enabled;
    public final String currencySymbol;

    public SellConfig(Plugin plugin) {
        this.plugin = plugin;
        this.loadPricesFromShopConfigs();
        FileConfiguration config = plugin.getConfig();
        this.guiTitle = config.getString("sellgui.title", "<gold>\ud83d\udcb0 Sell Items");
        this.guiSize = config.getInt("sellgui.size", 45);
        this.enabled = config.getBoolean("sellgui.enabled", true);
        this.currencySymbol = config.getString("sellgui.currency-symbol", "$");
        plugin.getLogger().info("[SellGUI] Loaded " + this.sellPrices.size() + " sellable items from shop configs");
    }

    private void loadPricesFromShopConfigs() {
        File shopFolder = new File(this.plugin.getDataFolder(), "shop");
        if (!shopFolder.exists() || !shopFolder.isDirectory()) {
            this.plugin.getLogger().warning("[SellGUI] Shop folder not found at " + shopFolder.getPath());
            return;
        }
        File[] files = shopFolder.listFiles(f -> f.getName().endsWith(".yml") && !f.getName().equals("main.yml"));
        if (files == null) {
            return;
        }
        for (File file : files) {
            try {
                YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
                if (!config.contains("items")) continue;
                for (String key : config.getConfigurationSection("items").getKeys(false)) {
                    Material mat;
                    String materialPath = "items." + key + ".material";
                    String sellPricePath = "items." + key + ".sell-price";
                    String matName = config.getString(materialPath);
                    double price = config.getDouble(sellPricePath, -1.0);
                    if (matName == null || !(price > 0.0) || (mat = Material.matchMaterial((String)matName.toUpperCase())) == null) continue;
                    this.sellPrices.put(mat, price);
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("[SellGUI] Error loading " + file.getName() + ": " + e.getMessage());
            }
        }
    }

    public boolean isSellable(Material material) {
        return this.sellPrices.containsKey(material) && this.sellPrices.get(material) > 0.0;
    }

    public double getSellPrice(Material material) {
        return this.sellPrices.getOrDefault(material, 0.0);
    }

    public int getSellableMaterialsCount() {
        return this.sellPrices.size();
    }
}

