/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.commands.impl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.lunark.io.commands.config.BalanceTopConfig;
import net.lunark.io.economy.ServerEssentialsEconomy;
import net.lunark.io.language.LanguageManager;
import net.lunark.io.language.PlayerLanguageManager;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public final class BalanceTopCommand
implements CommandExecutor {
    private static final String PERMISSION = "serveressentials.command.balancetop";
    private static final String COMMAND_NAME = "balancetop";
    private final PlayerLanguageManager langManager;
    private final BalanceTopConfig config;
    private final ServerEssentialsEconomy economy;

    public BalanceTopCommand(PlayerLanguageManager langManager, BalanceTopConfig config, ServerEssentialsEconomy economy) {
        this.langManager = langManager;
        this.config = config;
        this.economy = economy;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission(PERMISSION)) {
            Player p;
            Component message = this.langManager.getComponent(String.valueOf(sender instanceof Player ? (p = (Player)sender) : null), "commands.balancetop.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION));
            sender.sendMessage(message);
            return true;
        }
        int limit = this.config.getLimit();
        CompletableFuture.runAsync(() -> {
            List balances = Arrays.stream(Bukkit.getOfflinePlayers()).map(p -> new PlayerBalance(p.getUniqueId(), p.getName(), this.economy.getBalance((OfflinePlayer)p))).sorted(Comparator.comparingDouble(PlayerBalance::balance).reversed()).limit(limit).collect(Collectors.toList());
            Bukkit.getScheduler().runTask(Bukkit.getPluginManager().getPlugin("ServerEssentials"), () -> this.sendTopList(sender, balances, limit));
        });
        return true;
    }

    private void sendTopList(CommandSender sender, List<PlayerBalance> balances, int limit) {
        Player p;
        sender.sendMessage(this.langManager.getComponent(String.valueOf(sender instanceof Player ? (p = (Player)sender) : null), "commands.balancetop.header", "<gold>=== Top {limit} Richest Players ===", LanguageManager.ComponentPlaceholder.of("{limit}", String.valueOf(limit))));
        for (int i = 0; i < balances.size(); ++i) {
            Player p2;
            PlayerBalance pb = balances.get(i);
            String playerName = pb.name() != null ? pb.name() : "Unknown";
            sender.sendMessage(this.langManager.getComponent(String.valueOf(sender instanceof Player ? (p2 = (Player)sender) : null), "commands.balancetop.entry", "<yellow>#{rank} <white>{player} <gray>- <green>{balance}", LanguageManager.ComponentPlaceholder.of("{rank}", String.valueOf(i + 1)), LanguageManager.ComponentPlaceholder.of("{player}", playerName), LanguageManager.ComponentPlaceholder.of("{balance}", String.format("%.2f", pb.balance()))));
        }
        sender.sendMessage(this.langManager.getComponent(String.valueOf(sender instanceof Player ? (p = (Player)sender) : null), "commands.balancetop.footer", "<gold>=========================", new LanguageManager.ComponentPlaceholder[0]));
    }

    private record PlayerBalance(UUID uuid, String name, double balance) {
    }
}

