/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.commands.impl;

import java.util.Set;
import java.util.UUID;
import net.lunark.io.commands.CommandDataStorage;
import net.lunark.io.commands.config.BreakConfig;
import net.lunark.io.language.LanguageManager;
import net.lunark.io.language.PlayerLanguageManager;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public final class BreakCommand
implements CommandExecutor {
    private static final String PERMISSION = "serveressentials.command.break";
    private final PlayerLanguageManager langManager;
    private final BreakConfig config;
    private final CommandDataStorage dataStorage;

    public BreakCommand(PlayerLanguageManager langManager, BreakConfig config, CommandDataStorage dataStorage) {
        this.langManager = langManager;
        this.config = config;
        this.dataStorage = dataStorage;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.langManager.getMessageFor(null, "commands.break.only-player", "<red>Only players can use this command.", new LanguageManager.ComponentPlaceholder[0]).toString());
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission(PERMISSION)) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.break.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION)));
            return true;
        }
        Block targetBlock = player.getTargetBlock(Set.of(Material.AIR, Material.CAVE_AIR, Material.VOID_AIR), this.config.maxDistance());
        if (targetBlock == null || targetBlock.getType().isAir()) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.break.no-block", "<red>You are not looking at a breakable block within <yellow>{distance}</yellow> blocks.", LanguageManager.ComponentPlaceholder.of("{distance}", this.config.maxDistance())));
            return true;
        }
        targetBlock.setType(Material.AIR);
        player.sendMessage(this.langManager.getMessageFor(player, "commands.break.success", "<green>Broke the block at <yellow>{x}, {y}, {z}</yellow>.", LanguageManager.ComponentPlaceholder.of("{x}", targetBlock.getX()), LanguageManager.ComponentPlaceholder.of("{y}", targetBlock.getY()), LanguageManager.ComponentPlaceholder.of("{z}", targetBlock.getZ())));
        UUID playerId = player.getUniqueId();
        this.dataStorage.getState(playerId, "break", "usage_count").thenAccept(opt -> {
            int count = opt.map(Integer::parseInt).orElse(0);
            this.dataStorage.setState(playerId, "break", "usage_count", String.valueOf(count + 1));
        });
        return true;
    }
}

