/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.commands.impl;

import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.lunark.io.commands.CommandDataStorage;
import net.lunark.io.commands.config.GodConfig;
import net.lunark.io.language.LanguageManager;
import net.lunark.io.language.PlayerLanguageManager;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public final class GodCommand
implements CommandExecutor {
    private static final String PERMISSION = "serveressentials.command.god";
    private static final String COMMAND_NAME = "god";
    private final Set<UUID> godModeCache = ConcurrentHashMap.newKeySet();
    private final PlayerLanguageManager langManager;
    private final GodConfig config;
    private final CommandDataStorage dataStorage;

    public GodCommand(PlayerLanguageManager langManager, GodConfig config, CommandDataStorage dataStorage) {
        this.langManager = langManager;
        this.config = config;
        this.dataStorage = dataStorage;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.langManager.getMessageFor(null, "commands.god.only-player", "<red>Only players can use this command!", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission(PERMISSION)) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.god.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION)));
            return true;
        }
        UUID playerId = player.getUniqueId();
        if (this.godModeCache.contains(playerId)) {
            this.godModeCache.remove(playerId);
            this.dataStorage.deleteState(playerId, COMMAND_NAME, "enabled");
            player.sendMessage(this.langManager.getMessageFor(player, "commands.god.disabled", "<red>God mode disabled.", new LanguageManager.ComponentPlaceholder[0]));
        } else {
            this.godModeCache.add(playerId);
            this.dataStorage.setState(playerId, COMMAND_NAME, "enabled", "true");
            player.sendMessage(this.langManager.getMessageFor(player, "commands.god.enabled", "<green>God mode enabled.", new LanguageManager.ComponentPlaceholder[0]));
        }
        return true;
    }

    public boolean isGodMode(UUID playerId) {
        return this.godModeCache.contains(playerId);
    }

    public void loadPlayerState(UUID playerId) {
        this.dataStorage.getState(playerId, COMMAND_NAME, "enabled").thenAccept(opt -> {
            if (opt.isPresent() && "true".equals(opt.get())) {
                this.godModeCache.add(playerId);
            }
        });
    }

    public void unloadPlayerState(UUID playerId) {
        this.godModeCache.remove(playerId);
    }
}

