/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.commands.impl;

import java.util.UUID;
import net.lunark.io.commands.CommandDataStorage;
import net.lunark.io.commands.config.HatConfig;
import net.lunark.io.language.LanguageManager;
import net.lunark.io.language.PlayerLanguageManager;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public final class HatCommand
implements CommandExecutor {
    private static final String PERMISSION = "serveressentials.command.hat";
    private final PlayerLanguageManager langManager;
    private final HatConfig config;
    private final CommandDataStorage dataStorage;

    public HatCommand(PlayerLanguageManager langManager, HatConfig config, CommandDataStorage dataStorage) {
        this.langManager = langManager;
        this.config = config;
        this.dataStorage = dataStorage;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.langManager.getMessageFor(null, "commands.hat.only-player", "<red>Only players can use this command.", new LanguageManager.ComponentPlaceholder[0]).toString());
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission(PERMISSION)) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.hat.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION)));
            return true;
        }
        ItemStack handItem = player.getInventory().getItemInMainHand();
        if (handItem == null || handItem.getType().isAir()) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.hat.no-item", "<red>You must hold an item in your main hand to wear it as a hat!", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        if (!this.config.isAllowedItem(handItem.getType())) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.hat.item-not-allowed", "<red>This item cannot be worn as a hat! See allowed items in config.", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        ItemStack currentHelmet = player.getInventory().getHelmet();
        player.getInventory().setHelmet(handItem.clone());
        player.getInventory().setItemInMainHand(currentHelmet);
        player.sendMessage(this.langManager.getMessageFor(player, "commands.hat.success", "<green>\u2713 Your hat has been updated!", new LanguageManager.ComponentPlaceholder[0]));
        UUID playerId = player.getUniqueId();
        this.dataStorage.getState(playerId, "hat", "usage_count").thenAccept(opt -> {
            int count = opt.map(Integer::parseInt).orElse(0);
            this.dataStorage.setState(playerId, "hat", "usage_count", String.valueOf(count + 1));
            this.dataStorage.setState(playerId, "hat", "last_item", handItem.getType().toString());
        });
        return true;
    }
}

