/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.commands.impl;

import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.lunark.io.homes.HomeGUIListener;
import net.lunark.io.language.LanguageManager;
import net.lunark.io.language.PlayerLanguageManager;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public final class HomeCommand
implements CommandExecutor {
    private final Plugin plugin;
    private final PlayerLanguageManager langManager;
    private final HomeGUIListener guiListener;
    private static final String PERMISSION_BASE = "serveressentials.command.homes";
    private final LegacyComponentSerializer legacySerializer = LegacyComponentSerializer.legacySection();

    public HomeCommand(Plugin plugin, PlayerLanguageManager langManager, HomeGUIListener guiListener) {
        this.plugin = plugin;
        this.langManager = langManager;
        this.guiListener = guiListener;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.legacySerializer.serialize(this.langManager.getMessageFor(null, "commands.homes.only-player", "<red>Only players can use this command!", new LanguageManager.ComponentPlaceholder[0])));
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission(PERMISSION_BASE)) {
            player.sendMessage(this.legacySerializer.serialize(this.langManager.getMessageFor(player, "commands.no-permission", "<red>You need permission <yellow><permission></yellow>!", LanguageManager.ComponentPlaceholder.of("<permission>", PERMISSION_BASE))));
            return true;
        }
        this.guiListener.openMainGUI(player);
        return true;
    }
}

