/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.commands.impl;

import java.util.UUID;
import net.lunark.io.commands.CommandDataStorage;
import net.lunark.io.commands.config.NukeConfig;
import net.lunark.io.language.LanguageManager;
import net.lunark.io.language.PlayerLanguageManager;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public final class NukeCommand
implements CommandExecutor {
    private static final String PERMISSION = "serveressentials.command.nuke";
    private final PlayerLanguageManager langManager;
    private final NukeConfig config;
    private final CommandDataStorage dataStorage;

    public NukeCommand(PlayerLanguageManager langManager, NukeConfig config, CommandDataStorage dataStorage) {
        this.langManager = langManager;
        this.config = config;
        this.dataStorage = dataStorage;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.langManager.getMessageFor(null, "commands.nuke.only-player", "<red>Only players can use this command!", new LanguageManager.ComponentPlaceholder[0]).toString());
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission(PERMISSION)) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.nuke.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION)));
            return true;
        }
        World world = player.getWorld();
        Location loc = player.getLocation();
        world.createExplosion(loc, this.config.explosionPower(), this.config.setFire(), this.config.breakBlocks());
        player.sendMessage(this.langManager.getMessageFor(player, "commands.nuke.deployed", "<green>Nuke deployed! <gray>(Power: {power})", LanguageManager.ComponentPlaceholder.of("{power}", Float.valueOf(this.config.explosionPower()))));
        UUID playerId = player.getUniqueId();
        this.dataStorage.getState(playerId, "nuke", "usage_count").thenAccept(opt -> {
            int count = opt.map(Integer::parseInt).orElse(0);
            this.dataStorage.setState(playerId, "nuke", "usage_count", String.valueOf(count + 1));
            this.dataStorage.setState(playerId, "nuke", "last_used", String.valueOf(System.currentTimeMillis()));
        });
        return true;
    }
}

