/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.commands.impl;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.lunark.io.commands.config.PayToggleConfig;
import net.lunark.io.economy.ServerEssentialsEconomy;
import net.lunark.io.language.LanguageManager;
import net.lunark.io.language.PlayerLanguageManager;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public final class PayToggleCommand
implements CommandExecutor {
    private static final String PERMISSION = "serveressentials.command.paytoggle";
    private static final String COMMAND_NAME = "paytoggle";
    private final PlayerLanguageManager langManager;
    private final PayToggleConfig config;
    private final ServerEssentialsEconomy economy;

    public PayToggleCommand(PlayerLanguageManager langManager, PayToggleConfig config, Economy economy) {
        this.langManager = langManager;
        this.config = config;
        if (!(economy instanceof ServerEssentialsEconomy)) {
            throw new IllegalArgumentException("Economy must be ServerEssentialsEconomy implementation");
        }
        this.economy = (ServerEssentialsEconomy)economy;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.langManager.getMessageFor(null, "commands.paytoggle.only-player", "<red>Only players can use this command.", new LanguageManager.ComponentPlaceholder[0]).toString());
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission(PERMISSION)) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.paytoggle.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION)));
            return true;
        }
        UUID playerId = player.getUniqueId();
        String playerName = player.getName();
        ((CompletableFuture)this.economy.hasPaymentsDisabled(playerId).thenCompose(disabled -> {
            boolean newState = disabled == false;
            return this.economy.setPaymentsDisabled(playerId, playerName, newState).thenRun(() -> {
                String messageKey = newState ? "commands.paytoggle.disabled" : "commands.paytoggle.enabled";
                player.sendMessage(this.langManager.getMessageFor(player, messageKey, "<green>Payments have been <yellow>{state}</yellow>.", LanguageManager.ComponentPlaceholder.of("{state}", newState ? "disabled" : "enabled")));
            });
        })).exceptionally(ex -> {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.paytoggle.error", "<red>Error toggling payment state. Please try again.", new LanguageManager.ComponentPlaceholder[0]));
            return null;
        });
        return true;
    }
}

