/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.commands.impl;

import java.util.UUID;
import net.lunark.io.commands.CommandDataStorage;
import net.lunark.io.commands.config.PingConfig;
import net.lunark.io.language.LanguageManager;
import net.lunark.io.language.PlayerLanguageManager;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public final class PingCommand
implements CommandExecutor {
    private static final String PERMISSION = "serveressentials.command.ping";
    private final PlayerLanguageManager langManager;
    private final PingConfig config;
    private final CommandDataStorage dataStorage;

    public PingCommand(PlayerLanguageManager langManager, PingConfig config, CommandDataStorage dataStorage) {
        this.langManager = langManager;
        this.config = config;
        this.dataStorage = dataStorage;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.langManager.getMessageFor(null, "commands.ping.only-player", "<red>Only players can use this command.", new LanguageManager.ComponentPlaceholder[0]).toString());
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission(PERMISSION)) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.ping.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION)));
            return true;
        }
        int ping = player.getPing();
        String pingColor = ping < 50 ? "<green>" : (ping < 100 ? "<yellow>" : (ping < 200 ? "<gold>" : "<red>"));
        player.sendMessage(this.langManager.getMessageFor(player, "commands.ping.show", "<gray>Your ping: " + pingColor + "{ping}ms", LanguageManager.ComponentPlaceholder.of("{ping}", ping)));
        UUID playerId = player.getUniqueId();
        this.dataStorage.getState(playerId, "ping", "usage_count").thenAccept(opt -> {
            int count = opt.map(Integer::parseInt).orElse(0);
            this.dataStorage.setState(playerId, "ping", "usage_count", String.valueOf(count + 1));
            this.dataStorage.setState(playerId, "ping", "last_ping", String.valueOf(ping));
            this.dataStorage.setState(playerId, "ping", "last_checked", String.valueOf(System.currentTimeMillis()));
        });
        return true;
    }
}

