/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.commands.impl;

import java.util.UUID;
import net.lunark.io.Managers.SessionManager;
import net.lunark.io.commands.CommandDataStorage;
import net.lunark.io.commands.config.SessionConfig;
import net.lunark.io.language.LanguageManager;
import net.lunark.io.language.PlayerLanguageManager;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public final class SessionCommand
implements CommandExecutor {
    private static final String PERMISSION = "serveressentials.command.session";
    private final PlayerLanguageManager langManager;
    private final SessionConfig config;
    private final SessionManager sessionManager;
    private final CommandDataStorage dataStorage;

    public SessionCommand(PlayerLanguageManager langManager, SessionConfig config, SessionManager sessionManager, CommandDataStorage dataStorage) {
        this.langManager = langManager;
        this.config = config;
        this.sessionManager = sessionManager;
        this.dataStorage = dataStorage;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.langManager.getMessageFor(null, "commands.session.only-player", "<red>Only players can use this command.", new LanguageManager.ComponentPlaceholder[0]).toString());
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission(PERMISSION)) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.session.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION)));
            return true;
        }
        long current = this.sessionManager.getCurrentSession(player);
        if (current == 0L) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.session.not-tracked", "<yellow>Your session is not being tracked.<gray> (Rejoin to start tracking)", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        this.sessionManager.getLongestSession(player).thenAccept(longest -> {
            String currentStr = this.formatDuration(current);
            String longestStr = this.formatDuration((long)longest);
            player.sendMessage(this.langManager.getMessageFor(player, "commands.session.info", "<green>Session Info:\n<gray>Current: <white>{current}\n<gray>Longest: <white>{longest}", LanguageManager.ComponentPlaceholder.of("{current}", currentStr), LanguageManager.ComponentPlaceholder.of("{longest}", longestStr)));
            UUID playerId = player.getUniqueId();
            this.dataStorage.getState(playerId, "session", "usage_count").thenAccept(opt -> {
                int count = opt.map(Integer::parseInt).orElse(0);
                this.dataStorage.setState(playerId, "session", "usage_count", String.valueOf(count + 1));
                this.dataStorage.setState(playerId, "session", "last_checked", String.valueOf(System.currentTimeMillis()));
            });
        });
        return true;
    }

    private String formatDuration(long millis) {
        long seconds = millis / 1000L % 60L;
        long minutes = millis / 60000L % 60L;
        long hours = millis / 3600000L;
        return String.format("%02dh %02dm %02ds", hours, minutes, seconds);
    }
}

