/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.commands.impl;

import java.util.UUID;
import net.lunark.io.commands.CommandDataStorage;
import net.lunark.io.commands.config.SpeedConfig;
import net.lunark.io.language.LanguageManager;
import net.lunark.io.language.PlayerLanguageManager;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public final class SpeedCommand
implements CommandExecutor {
    private static final String PERMISSION = "serveressentials.command.speed";
    private final PlayerLanguageManager langManager;
    private final SpeedConfig config;
    private final CommandDataStorage dataStorage;

    public SpeedCommand(PlayerLanguageManager langManager, SpeedConfig config, CommandDataStorage dataStorage) {
        this.langManager = langManager;
        this.config = config;
        this.dataStorage = dataStorage;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.langManager.getMessageFor(null, "commands.speed.only-player", "<red>Only players can use this command.", new LanguageManager.ComponentPlaceholder[0]).toString());
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission(PERMISSION)) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.speed.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION)));
            return true;
        }
        if (args.length != 1) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.speed.usage", "<red>Usage: <white>/speed <1-10>", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        try {
            int speed = Integer.parseInt(args[0]);
            if (speed < 1 || speed > 10) {
                throw new NumberFormatException("Speed must be between 1-10");
            }
            float scaled = (float)speed / 10.0f;
            if (player.isFlying()) {
                player.setFlySpeed(scaled);
                player.sendMessage(this.langManager.getMessageFor(player, "commands.speed.fly-set", "<green>Fly speed set to <gold>{speed}", LanguageManager.ComponentPlaceholder.of("{speed}", speed)));
            } else {
                player.setWalkSpeed(scaled);
                player.sendMessage(this.langManager.getMessageFor(player, "commands.speed.walk-set", "<green>Walk speed set to <gold>{speed}", LanguageManager.ComponentPlaceholder.of("{speed}", speed)));
            }
            this.trackUsage(player.getUniqueId(), speed, true);
        }
        catch (NumberFormatException e) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.speed.invalid-number", "<red>Invalid number! Speed must be between <yellow>1-10", new LanguageManager.ComponentPlaceholder[0]));
            this.trackUsage(player.getUniqueId(), 0, false);
        }
        return true;
    }

    private void trackUsage(UUID playerId, int speed, boolean success) {
        this.dataStorage.getState(playerId, "speed", "usage_count").thenAccept(opt -> {
            int count = opt.map(Integer::parseInt).orElse(0);
            this.dataStorage.setState(playerId, "speed", "usage_count", String.valueOf(count + 1));
            this.dataStorage.setState(playerId, "speed", "last_speed", String.valueOf(speed));
            this.dataStorage.setState(playerId, "speed", "last_success", String.valueOf(success));
        });
    }
}

