/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.commands.impl;

import java.util.UUID;
import net.lunark.io.commands.CommandDataStorage;
import net.lunark.io.commands.config.TopConfig;
import net.lunark.io.language.LanguageManager;
import net.lunark.io.language.PlayerLanguageManager;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public final class TopCommand
implements CommandExecutor {
    private static final String PERMISSION = "serveressentials.command.top";
    private final PlayerLanguageManager langManager;
    private final TopConfig config;
    private final CommandDataStorage dataStorage;

    public TopCommand(PlayerLanguageManager langManager, TopConfig config, CommandDataStorage dataStorage) {
        this.langManager = langManager;
        this.config = config;
        this.dataStorage = dataStorage;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.langManager.getMessageFor(null, "commands.top.only-player", "<red>Only players can use this command.", new LanguageManager.ComponentPlaceholder[0]).toString());
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission(PERMISSION)) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.top.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION)));
            return true;
        }
        Location loc = player.getLocation();
        boolean teleported = false;
        for (int y = loc.getWorld().getMaxHeight() - 1; y > loc.getBlockY(); --y) {
            Location check = new Location(loc.getWorld(), loc.getX(), (double)y, loc.getZ());
            if (check.getBlock().getType() == Material.AIR) continue;
            player.teleport(check.add(0.0, 1.0, 0.0));
            player.sendMessage(this.langManager.getMessageFor(player, "commands.top.teleported", "<green>Teleported to the highest block above you!", new LanguageManager.ComponentPlaceholder[0]));
            teleported = true;
            break;
        }
        if (!teleported) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.top.no-block", "<red>No solid block found above you!", new LanguageManager.ComponentPlaceholder[0]));
        }
        UUID playerId = player.getUniqueId();
        this.dataStorage.getState(playerId, "top", "usage_count").thenAccept(opt -> {
            int count = opt.map(Integer::parseInt).orElse(0);
            this.dataStorage.setState(playerId, "top", "usage_count", String.valueOf(count + 1));
            this.dataStorage.setState(playerId, "top", "last_used", String.valueOf(System.currentTimeMillis()));
        });
        return true;
    }
}

