/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.commands.impl;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.lunark.io.commands.CommandDataStorage;
import net.lunark.io.commands.CommandModule;
import net.lunark.io.language.LanguageManager;
import net.lunark.io.language.PlayerLanguageManager;
import net.lunark.io.warp.WarpManager;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class WarpDeleteCommand
extends CommandModule
implements CommandExecutor {
    private final WarpManager warpManager;

    public WarpDeleteCommand(WarpManager warpManager, PlayerLanguageManager langManager, CommandDataStorage commandStorage) {
        super(commandStorage, langManager);
        this.warpManager = warpManager;
    }

    @Override
    protected String getCommandName() {
        return "delwarp";
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.langManager.getMessageFor(null, "commands.only-players", "<red>This command can only be used by players!", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        Player player = (Player)sender;
        if (args.length != 1) {
            player.sendMessage(this.langManager.getMessageFor(player, "delwarp.usage", "<red>Usage: <yellow>/delwarp <name>", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        if (!player.hasPermission("serveressentials.command.delwarp")) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", "serveressentials.command.delwarp")));
            return true;
        }
        String warpName = args[0].toLowerCase();
        this.warpManager.exists(warpName).thenCompose(exists -> {
            if (!exists.booleanValue()) {
                player.sendMessage(this.langManager.getMessageFor(player, "delwarp.not-found", "<red>Warp <yellow>{warp}</yellow> not found.", LanguageManager.ComponentPlaceholder.of("{warp}", warpName)));
                return CompletableFuture.completedFuture(null);
            }
            return this.warpManager.getCreator(warpName).thenCompose(optCreator -> {
                UUID creator = optCreator.orElse(null);
                if (creator == null || !creator.equals(player.getUniqueId()) && !player.hasPermission("serveressentials.command.delwarp.others")) {
                    player.sendMessage(this.langManager.getMessageFor(player, "delwarp.no-permission", "<red>You don't have permission to delete this warp!", new LanguageManager.ComponentPlaceholder[0]));
                    return CompletableFuture.completedFuture(null);
                }
                return this.warpManager.removeWarp(warpName).thenRun(() -> player.sendMessage(this.langManager.getMessageFor(player, "delwarp.success", "<green>Deleted warp <yellow>{warp}</yellow>!", LanguageManager.ComponentPlaceholder.of("{warp}", warpName))));
            });
        });
        return true;
    }
}

