/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.daily;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.lunark.io.daily.DailyReward;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class DailyConfig {
    private final Plugin plugin;
    private final File configFile;
    private FileConfiguration config;
    public final int cooldownHours;
    public final String guiTitle;
    public final int guiRows;
    public final Map<Integer, DailyReward> rewards;

    public DailyConfig(Plugin plugin) {
        this.plugin = plugin;
        this.configFile = new File(plugin.getDataFolder(), "daily.yml");
        this.saveDefaultConfig();
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
        this.cooldownHours = this.config.getInt("cooldown", 24);
        this.guiTitle = this.config.getString("gui.title", "Daily Rewards");
        this.guiRows = Math.max(1, Math.min(6, this.config.getInt("gui.rows", 6)));
        this.rewards = this.loadRewards();
    }

    private void saveDefaultConfig() {
        if (!this.configFile.exists()) {
            try (InputStream in = this.plugin.getResource("daily.yml");){
                if (in != null) {
                    Files.copy(in, this.configFile.toPath(), new CopyOption[0]);
                } else {
                    this.configFile.createNewFile();
                }
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Failed to save default daily.yml!");
            }
        }
    }

    private Map<Integer, DailyReward> loadRewards() {
        HashMap<Integer, DailyReward> loaded = new HashMap<Integer, DailyReward>();
        ConfigurationSection rewardsSection = this.config.getConfigurationSection("rewards");
        if (rewardsSection == null) {
            this.plugin.getLogger().warning("No rewards section found in daily.yml!");
            return loaded;
        }
        for (String key : rewardsSection.getKeys(false)) {
            try {
                int day = Integer.parseInt(key);
                ConfigurationSection rewardSection = rewardsSection.getConfigurationSection(key);
                if (rewardSection == null) continue;
                int slot = rewardSection.getInt("slot", -1);
                int page = rewardSection.getInt("page", 1);
                ArrayList<DailyReward.RewardItem> items = new ArrayList<DailyReward.RewardItem>();
                List itemList = rewardSection.getList("items");
                if (itemList != null) {
                    for (Object obj : itemList) {
                        if (obj instanceof ConfigurationSection) {
                            ConfigurationSection itemSection = (ConfigurationSection)obj;
                            items.add(this.parseRewardItem(itemSection));
                            continue;
                        }
                        if (!(obj instanceof Map)) continue;
                        Map itemMap = (Map)obj;
                        items.add(this.parseRewardItemFromMap(itemMap));
                    }
                }
                DailyReward reward = new DailyReward(day, slot, page, items);
                loaded.put(day, reward);
            }
            catch (NumberFormatException e) {
                this.plugin.getLogger().warning("Invalid day key: " + key + " in daily.yml");
            }
        }
        return loaded;
    }

    private DailyReward.RewardItem parseRewardItem(ConfigurationSection section) {
        ConfigurationSection nbtSection;
        List enchList;
        String materialName = section.getString("type", "DIAMOND");
        Material material = Material.matchMaterial((String)materialName);
        if (material == null) {
            material = Material.DIAMOND;
            this.plugin.getLogger().warning("Invalid material: " + materialName);
        }
        int amount = section.getInt("amount", 1);
        String name = section.getString("name", "");
        ArrayList<String> lore = new ArrayList();
        if (section.contains("lore")) {
            lore = section.getStringList("lore");
        }
        boolean glow = section.getBoolean("glow", false);
        HashMap<String, Integer> enchantments = new HashMap<String, Integer>();
        if (section.contains("enchantments") && (enchList = section.getList("enchantments")) != null) {
            for (Object obj : enchList) {
                String enchStr;
                String[] parts;
                if (!(obj instanceof String) || (parts = (enchStr = (String)obj).split(":")).length != 2) continue;
                try {
                    enchantments.put(parts[0], Integer.parseInt(parts[1]));
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        HashMap<String, String> nbt = new HashMap<String, String>();
        if (section.contains("nbt") && (nbtSection = section.getConfigurationSection("nbt")) != null) {
            for (String key : nbtSection.getKeys(false)) {
                nbt.put(key, nbtSection.getString(key, ""));
            }
        }
        return new DailyReward.RewardItem(material, amount, name, lore, enchantments, glow, nbt);
    }

    private DailyReward.RewardItem parseRewardItemFromMap(Map<?, ?> map) {
        Object glowObj;
        Object typeObj = map.get("type");
        String materialName = typeObj instanceof String ? (String)typeObj : "DIAMOND";
        Material material = Material.matchMaterial((String)materialName);
        if (material == null) {
            material = Material.DIAMOND;
            this.plugin.getLogger().warning("Invalid material: " + materialName);
        }
        Object amtObj = map.get("amount");
        int amount = 1;
        if (amtObj instanceof Number) {
            amount = ((Number)amtObj).intValue();
        } else if (amtObj != null) {
            try {
                amount = Integer.parseInt(amtObj.toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        Object nameObj = map.get("name");
        String name = nameObj instanceof String ? (String)nameObj : "";
        ArrayList<String> lore = new ArrayList<String>();
        Object loreObj = map.get("lore");
        if (loreObj instanceof List) {
            for (Object line : (List)loreObj) {
                if (!(line instanceof String)) continue;
                lore.add((String)line);
            }
        }
        boolean glow = (glowObj = map.get("glow")) instanceof Boolean ? (Boolean)glowObj : false;
        HashMap<String, Integer> enchantments = new HashMap<String, Integer>();
        HashMap<String, String> nbt = new HashMap<String, String>();
        return new DailyReward.RewardItem(material, amount, name, lore, enchantments, glow, nbt);
    }

    public void reload() {
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
        this.rewards.clear();
        this.rewards.putAll(this.loadRewards());
    }
}

