/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.economy;

import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import net.lunark.io.database.DatabaseManager;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.Plugin;

public class ServerEssentialsEconomy
implements Economy {
    private final Plugin plugin;
    private final DatabaseManager databaseManager;
    private final String poolKey = "economy";

    public ServerEssentialsEconomy(Plugin plugin, DatabaseManager databaseManager) {
        this.plugin = plugin;
        this.databaseManager = databaseManager;
        this.initializeDatabase();
    }

    private void initializeDatabase() {
        String balancesSql = "CREATE TABLE IF NOT EXISTS economy_balances (player_uuid TEXT PRIMARY KEY, player_name TEXT NOT NULL, balance REAL NOT NULL DEFAULT 0.0)";
        String settingsSql = "CREATE TABLE IF NOT EXISTS economy_settings (player_uuid TEXT PRIMARY KEY, player_name TEXT NOT NULL, payments_disabled BOOLEAN NOT NULL DEFAULT FALSE, pay_confirm_disabled BOOLEAN NOT NULL DEFAULT FALSE)";
        CompletableFuture.allOf(this.databaseManager.executeUpdate("economy", balancesSql, new Object[0]), this.databaseManager.executeUpdate("economy", settingsSql, new Object[0])).join();
        this.plugin.getLogger().info("[Economy] Tables initialized");
    }

    public CompletableFuture<Boolean> hasPayConfirmDisabled(UUID playerUuid) {
        String sql = "SELECT pay_confirm_disabled FROM economy_settings WHERE player_uuid = ?";
        return this.databaseManager.executeQuery("economy", sql, rs -> rs.next() ? rs.getBoolean("pay_confirm_disabled") : false, playerUuid.toString()).thenApply(opt -> opt.orElse(false));
    }

    public CompletableFuture<Void> setPayConfirmDisabled(UUID playerUuid, String playerName, boolean disabled) {
        String sql = "INSERT OR REPLACE INTO economy_settings (player_uuid, player_name, payments_disabled, pay_confirm_disabled) VALUES (?, ?, COALESCE((SELECT payments_disabled FROM economy_settings WHERE player_uuid = ?), FALSE), ?)";
        return this.databaseManager.executeUpdate("economy", sql, playerUuid.toString(), playerName, playerUuid.toString(), disabled);
    }

    public CompletableFuture<Boolean> hasPaymentsDisabled(UUID playerUuid) {
        String sql = "SELECT payments_disabled FROM economy_settings WHERE player_uuid = ?";
        return this.databaseManager.executeQuery("economy", sql, rs -> rs.next() ? rs.getBoolean("payments_disabled") : false, playerUuid.toString()).thenApply(opt -> opt.orElse(false));
    }

    public CompletableFuture<Void> setPaymentsDisabled(UUID playerUuid, String playerName, boolean disabled) {
        String sql = "INSERT OR REPLACE INTO economy_settings (player_uuid, player_name, payments_disabled) VALUES (?, ?, ?)";
        return this.databaseManager.executeUpdate("economy", sql, playerUuid.toString(), playerName, disabled);
    }

    private CompletableFuture<Double> getBalanceAsync(UUID playerUuid) {
        String sql = "SELECT balance FROM economy_balances WHERE player_uuid = ?";
        return ((CompletableFuture)this.databaseManager.executeQuery("economy", sql, rs -> rs.next() ? rs.getDouble("balance") : 0.0, playerUuid.toString()).thenApply(opt -> opt.orElse(0.0))).exceptionally(ex -> {
            this.plugin.getLogger().log(Level.SEVERE, "[Economy] Failed to get balance for " + String.valueOf(playerUuid), (Throwable)ex);
            return 0.0;
        });
    }

    private CompletableFuture<Void> setBalanceAsync(UUID playerUuid, String playerName, double amount) {
        String sql = "INSERT OR REPLACE INTO economy_balances (player_uuid, player_name, balance) VALUES (?, ?, ?)";
        return this.databaseManager.executeUpdate("economy", sql, playerUuid.toString(), playerName, Math.max(0.0, amount));
    }

    public boolean isEnabled() {
        return true;
    }

    public String getName() {
        return "ServerEssentials";
    }

    public boolean hasBankSupport() {
        return false;
    }

    public int fractionalDigits() {
        return 2;
    }

    public String format(double amount) {
        return String.format("$%.2f", amount);
    }

    public String currencyNamePlural() {
        return "Dollars";
    }

    public String currencyNameSingular() {
        return "Dollar";
    }

    public boolean hasAccount(String s) {
        return false;
    }

    public boolean hasAccount(OfflinePlayer player) {
        return true;
    }

    public boolean hasAccount(String s, String s1) {
        return false;
    }

    public boolean hasAccount(OfflinePlayer player, String worldName) {
        return this.hasAccount(player);
    }

    public double getBalance(String s) {
        return 0.0;
    }

    public double getBalance(OfflinePlayer player) {
        try {
            return this.getBalanceAsync(player.getUniqueId()).get(5L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("[Economy] Timeout getting balance for " + player.getName());
            return 0.0;
        }
    }

    public double getBalance(String s, String s1) {
        return 0.0;
    }

    public double getBalance(OfflinePlayer player, String world) {
        return this.getBalance(player);
    }

    public boolean has(String s, double v) {
        return false;
    }

    public boolean has(OfflinePlayer player, double amount) {
        try {
            return this.getBalanceAsync(player.getUniqueId()).get(5L, TimeUnit.SECONDS) >= amount;
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("[Economy] Timeout checking balance for " + player.getName());
            return false;
        }
    }

    public boolean has(String s, String s1, double v) {
        return false;
    }

    public boolean has(OfflinePlayer player, String worldName, double amount) {
        return this.has(player, amount);
    }

    public EconomyResponse withdrawPlayer(String s, double v) {
        return null;
    }

    public EconomyResponse withdrawPlayer(OfflinePlayer player, double amount) {
        if (amount < 0.0) {
            return new EconomyResponse(0.0, this.getBalance(player), EconomyResponse.ResponseType.FAILURE, "Cannot withdraw negative funds");
        }
        try {
            UUID uuid = player.getUniqueId();
            double currentBalance = this.getBalanceAsync(uuid).get(5L, TimeUnit.SECONDS);
            if (currentBalance < amount) {
                return new EconomyResponse(0.0, currentBalance, EconomyResponse.ResponseType.FAILURE, "Insufficient funds");
            }
            double newBalance = currentBalance - amount;
            this.setBalanceAsync(uuid, player.getName(), newBalance).get(5L, TimeUnit.SECONDS);
            return new EconomyResponse(amount, newBalance, EconomyResponse.ResponseType.SUCCESS, null);
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("[Economy] Withdraw failed for " + player.getName() + ": " + e.getMessage());
            return new EconomyResponse(0.0, this.getBalance(player), EconomyResponse.ResponseType.FAILURE, "Database error");
        }
    }

    public EconomyResponse withdrawPlayer(String s, String s1, double v) {
        return null;
    }

    public EconomyResponse withdrawPlayer(OfflinePlayer player, String worldName, double amount) {
        return this.withdrawPlayer(player, amount);
    }

    public EconomyResponse depositPlayer(String s, double v) {
        return null;
    }

    public EconomyResponse depositPlayer(OfflinePlayer player, double amount) {
        if (amount < 0.0) {
            return new EconomyResponse(0.0, this.getBalance(player), EconomyResponse.ResponseType.FAILURE, "Cannot deposit negative funds");
        }
        try {
            UUID uuid = player.getUniqueId();
            double currentBalance = this.getBalanceAsync(uuid).get(5L, TimeUnit.SECONDS);
            double newBalance = currentBalance + amount;
            this.setBalanceAsync(uuid, player.getName(), newBalance).get(5L, TimeUnit.SECONDS);
            return new EconomyResponse(amount, newBalance, EconomyResponse.ResponseType.SUCCESS, null);
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("[Economy] Deposit failed for " + player.getName() + ": " + e.getMessage());
            return new EconomyResponse(0.0, this.getBalance(player), EconomyResponse.ResponseType.FAILURE, "Database error");
        }
    }

    public EconomyResponse depositPlayer(String s, String s1, double v) {
        return null;
    }

    public EconomyResponse depositPlayer(OfflinePlayer player, String worldName, double amount) {
        return this.depositPlayer(player, amount);
    }

    public boolean createPlayerAccount(OfflinePlayer player) {
        return (Boolean)((CompletableFuture)((CompletableFuture)this.setBalanceAsync(player.getUniqueId(), player.getName(), 0.0).thenApply(v -> true)).exceptionally(ex -> false)).join();
    }

    public boolean createPlayerAccount(String s, String s1) {
        return false;
    }

    public boolean createPlayerAccount(OfflinePlayer player, String worldName) {
        return this.createPlayerAccount(player);
    }

    public EconomyResponse createBank(String name, String player) {
        return this.notSupported();
    }

    public EconomyResponse createBank(String s, OfflinePlayer offlinePlayer) {
        return this.notSupported();
    }

    public EconomyResponse deleteBank(String name) {
        return this.notSupported();
    }

    public EconomyResponse bankBalance(String name) {
        return this.notSupported();
    }

    public EconomyResponse bankHas(String name, double amount) {
        return this.notSupported();
    }

    public EconomyResponse bankWithdraw(String name, double amount) {
        return this.notSupported();
    }

    public EconomyResponse bankDeposit(String name, double amount) {
        return this.notSupported();
    }

    public EconomyResponse isBankOwner(String name, String playerName) {
        return this.notSupported();
    }

    public EconomyResponse isBankOwner(String s, OfflinePlayer offlinePlayer) {
        return this.notSupported();
    }

    public EconomyResponse isBankMember(String name, String playerName) {
        return this.notSupported();
    }

    public EconomyResponse isBankMember(String s, OfflinePlayer offlinePlayer) {
        return this.notSupported();
    }

    public List<String> getBanks() {
        return List.of();
    }

    public boolean createPlayerAccount(String s) {
        return false;
    }

    private EconomyResponse notSupported() {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Banks not supported");
    }
}

