/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.listeners;

import org.bukkit.ChatColor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class JoinLeaveListener
implements Listener {
    private final FileConfiguration config;

    public JoinLeaveListener(FileConfiguration config) {
        this.config = config;
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        String message = this.config.getString("messages.join", "&aWelcome &f%player% &ato the server!");
        event.setJoinMessage(this.formatMessage(message, event.getPlayer().getName()));
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        String message = this.config.getString("messages.leave", "&c%player% &fhas left the server.");
        event.setQuitMessage(this.formatMessage(message, event.getPlayer().getName()));
    }

    private String formatMessage(String message, String playerName) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message.replace("%player%", playerName));
    }
}

