/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.listeners;

import java.util.UUID;
import net.lunark.io.language.LanguageManager;
import net.lunark.io.language.PlayerLanguageManager;
import net.lunark.io.mute.MuteStorage;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;

public class MuteListener
implements Listener {
    private final MuteStorage storage;
    private final PlayerLanguageManager langManager;
    private final Plugin plugin;

    public MuteListener(MuteStorage storage, PlayerLanguageManager langManager, Plugin plugin) {
        this.storage = storage;
        this.langManager = langManager;
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        UUID uuid = event.getPlayer().getUniqueId();
        if (this.storage.isMutedSync(uuid)) {
            event.setCancelled(true);
            String reason = this.storage.getMuteReasonSync(uuid).orElse("No reason");
            this.plugin.getServer().getScheduler().runTask(this.plugin, () -> event.getPlayer().sendMessage(this.langManager.getMessageFor(event.getPlayer(), "mute.chat-blocked", "<red>You are muted! Reason: <white>{reason}</white>", LanguageManager.ComponentPlaceholder.of("{reason}", reason))));
            return;
        }
    }
}

