/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.mute;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.lunark.io.database.DatabaseManager;
import org.bukkit.plugin.Plugin;

public class MuteStorage {
    private final DatabaseManager dbManager;
    private final String poolKey = "mutes";
    private final Plugin plugin;

    public MuteStorage(Plugin plugin, DatabaseManager dbManager) {
        this.plugin = plugin;
        this.dbManager = dbManager;
        this.initTable();
    }

    private void initTable() {
        String sql = "CREATE TABLE IF NOT EXISTS mutes (\n    uuid TEXT PRIMARY KEY,\n    reason TEXT NOT NULL,\n    expires_at BIGINT NOT NULL\n)\n";
        this.dbManager.executeUpdate("mutes", sql, new Object[0]);
    }

    public CompletableFuture<Void> mutePlayer(UUID uuid, String reason, long expiresAt) {
        String sql = "INSERT OR REPLACE INTO mutes VALUES (?, ?, ?)";
        return this.dbManager.executeUpdate("mutes", sql, uuid.toString(), reason, expiresAt);
    }

    public CompletableFuture<Void> unmutePlayer(UUID uuid) {
        String sql = "DELETE FROM mutes WHERE uuid = ?";
        return this.dbManager.executeUpdate("mutes", sql, uuid.toString());
    }

    public CompletableFuture<Boolean> isMuted(UUID uuid) {
        String sql = "SELECT expires_at FROM mutes WHERE uuid = ?";
        return this.dbManager.executeQuery("mutes", sql, rs -> rs.next() ? Long.valueOf(rs.getLong("expires_at")) : null, uuid.toString()).thenApply(optExpires -> optExpires.map(expires -> {
            if (expires == -1L) {
                return true;
            }
            return System.currentTimeMillis() <= expires;
        }).orElse(false));
    }

    public CompletableFuture<Optional<MuteData>> getMuteData(UUID uuid) {
        String sql = "SELECT * FROM mutes WHERE uuid = ?";
        return this.dbManager.executeQuery("mutes", sql, this::mapMuteData, uuid.toString());
    }

    private MuteData mapMuteData(ResultSet rs) throws SQLException {
        if (!rs.next()) {
            return null;
        }
        return new MuteData(UUID.fromString(rs.getString("uuid")), rs.getString("reason"), rs.getLong("expires_at"));
    }

    public CompletableFuture<Set<UUID>> getAllMutedUUIDs() {
        String sql = "SELECT uuid FROM mutes";
        return this.dbManager.executeQuery("mutes", sql, rs -> {
            HashSet<UUID> uuids = new HashSet<UUID>();
            while (rs.next()) {
                uuids.add(UUID.fromString(rs.getString("uuid")));
            }
            return uuids;
        }, new Object[0]).thenApply(opt -> opt.orElseGet(HashSet::new));
    }

    public CompletableFuture<Optional<String>> getMuteReason(UUID uuid) {
        return this.getMuteData(uuid).thenApply(opt -> opt.map(MuteData::reason));
    }

    public boolean isMutedSync(UUID uuid) {
        try {
            return this.isMuted(uuid).get(2L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            this.plugin.getLogger().severe("Failed to check mute status for " + String.valueOf(uuid) + ": " + e.getMessage());
            return false;
        }
    }

    public Optional<MuteData> getMuteDataSync(UUID uuid) {
        try {
            return this.getMuteData(uuid).get(2L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Failed to retrieve mute data for " + String.valueOf(uuid) + ": " + e.getMessage());
            return Optional.empty();
        }
    }

    public Optional<String> getMuteReasonSync(UUID uuid) {
        try {
            return this.getMuteDataSync(uuid).map(MuteData::reason);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to retrieve mute reason for " + String.valueOf(uuid) + ": " + e.getMessage());
            return Optional.empty();
        }
    }

    public record MuteData(UUID uuid, String reason, long expiresAt) {
    }
}

