/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.scoreboard.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public final class PlaceholderUtil {
    private static final Pattern BUILTIN_PATTERN = Pattern.compile("\\{([^}]+)\\}");

    private PlaceholderUtil() {
    }

    public static String apply(Player player, String text) {
        if (text == null) {
            return "";
        }
        if (player == null) {
            return text;
        }
        String result = text;
        Matcher matcher = BUILTIN_PATTERN.matcher(result);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String placeholder = matcher.group(1);
            String value = PlaceholderUtil.getBuiltinPlaceholder(player, placeholder);
            matcher.appendReplacement(sb, Matcher.quoteReplacement(value));
        }
        matcher.appendTail(sb);
        result = sb.toString();
        try {
            return PlaceholderAPI.setPlaceholders((Player)player, (String)result);
        }
        catch (NoClassDefFoundError e) {
            return result;
        }
        catch (Exception e) {
            return result;
        }
    }

    private static String getBuiltinPlaceholder(Player player, String placeholder) {
        return switch (placeholder.toLowerCase()) {
            case "player_name" -> {
                String var4_4 = player.getName();
                yield var4_4;
            }
            case "player_uuid" -> {
                String var4_5 = player.getUniqueId().toString();
                yield var4_5;
            }
            case "world" -> {
                String var4_6 = player.getWorld().getName();
                yield var4_6;
            }
            case "online_players" -> {
                String var4_7 = String.valueOf(Bukkit.getOnlinePlayers().size());
                yield var4_7;
            }
            case "max_players" -> {
                String var4_8 = String.valueOf(Bukkit.getMaxPlayers());
                yield var4_8;
            }
            case "tps" -> {
                String var4_9 = String.format("%.1f", Bukkit.getTPS()[0]);
                yield var4_9;
            }
            case "ping" -> {
                try {
                    String var4_10 = String.valueOf(player.getPing());
                    yield var4_10;
                }
                catch (NoSuchMethodError e) {
                    String var4_11 = "N/A";
                    yield var4_11;
                }
            }
            default -> {
                String var4_12 = "{" + placeholder + "}";
                yield var4_12;
            }
        };
    }
}

