/*
 * Decompiled with CFR 0.152.
 */
package com.rumaruka.topaddon.mods.mekanism;

import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ProbeMode;
import mekanism.api.MekanismAPITags;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.IChemicalTank;
import mekanism.common.content.network.ChemicalNetwork;
import mekanism.common.tile.transmitter.TileEntityPressurizedTube;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class TOPChemicalProvider
implements IProbeInfoProvider {
    public ResourceLocation getID() {
        return ResourceLocation.fromNamespaceAndPath((String)"topaddons", (String)"test_gas_tank");
    }

    public void addProbeInfo(ProbeMode probeMode, IProbeInfo iProbeInfo, Player player, Level level, BlockState blockState, IProbeHitData iProbeHitData) {
        if (!level.isClientSide()) {
            BlockEntity blockEntity = level.getBlockEntity(iProbeHitData.getPos());
            if (player.isCrouching() && blockEntity instanceof TileEntityPressurizedTube) {
                TileEntityPressurizedTube tube = (TileEntityPressurizedTube)blockEntity;
                this.renderChemical(tube, iProbeInfo);
            }
        }
    }

    private void renderSlurry(TileEntityPressurizedTube tube, IProbeInfo iProbeInfo) {
        ChemicalNetwork transmitterNetwork = (ChemicalNetwork)tube.getTransmitter().getTransmitterNetwork();
        IChemicalTank slurryTank = transmitterNetwork.getChemicalTank();
        Holder typeHolder = slurryTank.getTypeHolder();
        if (!slurryTank.isEmpty() && (typeHolder.is(MekanismAPITags.Chemicals.DIRTY) || typeHolder.is(MekanismAPITags.Chemicals.CLEAN))) {
            long stored = slurryTank.getStored();
            long capacity = slurryTank.getCapacity();
            iProbeInfo.text(slurryTank.getStack().getTextComponent());
            iProbeInfo.progress(stored, capacity);
        }
    }

    private void renderGas(TileEntityPressurizedTube tube, IProbeInfo iProbeInfo) {
        ChemicalNetwork transmitterNetwork = (ChemicalNetwork)tube.getTransmitter().getTransmitterNetwork();
        IChemicalTank slurryTank = transmitterNetwork.getChemicalTank();
        Holder typeHolder = slurryTank.getTypeHolder();
        if (!slurryTank.isEmpty() && typeHolder.is(MekanismAPITags.Chemicals.GASEOUS)) {
            long stored = slurryTank.getStored();
            long capacity = slurryTank.getCapacity();
            iProbeInfo.text(slurryTank.getStack().getTextComponent());
            iProbeInfo.progress(stored, capacity);
        }
    }

    private void renderInfusion(TileEntityPressurizedTube tube, IProbeInfo iProbeInfo) {
        ChemicalNetwork transmitterNetwork = (ChemicalNetwork)tube.getTransmitter().getTransmitterNetwork();
        IChemicalTank slurryTank = transmitterNetwork.getChemicalTank();
        Holder typeHolder = slurryTank.getTypeHolder();
        if (!slurryTank.isEmpty() && (typeHolder.is(MekanismAPITags.Chemicals.GOLD) || typeHolder.is(MekanismAPITags.Chemicals.FUNGI) || typeHolder.is(MekanismAPITags.Chemicals.BIO) || typeHolder.is(MekanismAPITags.Chemicals.FUNGI) || typeHolder.is(MekanismAPITags.Chemicals.DIAMOND) || typeHolder.is(MekanismAPITags.Chemicals.CARBON) || typeHolder.is(MekanismAPITags.Chemicals.REDSTONE) || typeHolder.is(MekanismAPITags.Chemicals.REFINED_OBSIDIAN))) {
            long stored = slurryTank.getStored();
            long capacity = slurryTank.getCapacity();
            iProbeInfo.text(slurryTank.getStack().getTextComponent());
            iProbeInfo.progress(stored, capacity);
        }
    }

    private void renderChemical(TileEntityPressurizedTube tube, IProbeInfo iProbeInfo) {
        ChemicalNetwork transmitterNetwork = (ChemicalNetwork)tube.getTransmitter().getTransmitterNetwork();
        IChemicalTank slurryTank = transmitterNetwork.getChemicalTank();
        Holder typeHolder = slurryTank.getTypeHolder();
        if (!slurryTank.isEmpty() && typeHolder.value() instanceof Chemical) {
            long stored = slurryTank.getStored();
            long capacity = slurryTank.getCapacity();
            iProbeInfo.text(slurryTank.getStack().getTextComponent());
            iProbeInfo.progress(stored, capacity);
        }
    }
}

