/*
 * Decompiled with CFR 0.152.
 */
package com.hermitowo.tfcweldbutton.network;

import com.hermitowo.tfcweldbutton.network.PacketHandler;
import io.netty.buffer.ByteBuf;
import net.dries007.tfc.client.particle.TFCParticles;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.AnvilBlockEntity;
import net.dries007.tfc.common.container.AnvilContainer;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum WeldButtonPacket implements CustomPacketPayload
{
    PACKET;

    public static final CustomPacketPayload.Type<WeldButtonPacket> TYPE;
    public static final StreamCodec<ByteBuf, WeldButtonPacket> CODEC;

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    void handle(@Nullable ServerPlayer player) {
        InteractionResult weldResult;
        AnvilContainer container;
        AnvilBlockEntity anvil;
        AbstractContainerMenu abstractContainerMenu;
        if (player != null && (abstractContainerMenu = player.containerMenu) instanceof AnvilContainer && (Helpers.isItem((ItemStack)((AnvilBlockEntity.AnvilInventory)(anvil = (AnvilBlockEntity)(container = (AnvilContainer)abstractContainerMenu).getBlockEntity()).getInventory()).getStackInSlot(2), (TagKey)TFCTags.Items.TOOLS_HAMMER) || Helpers.isItem((ItemStack)player.getMainHandItem(), (TagKey)TFCTags.Items.TOOLS_HAMMER)) && (weldResult = anvil.weld((Player)player)).consumesAction()) {
            Level level = player.level();
            BlockPos pos = anvil.getBlockPos();
            if (level instanceof ServerLevel) {
                ServerLevel server = (ServerLevel)level;
                double x = (double)pos.getX() + Mth.nextDouble((RandomSource)level.random, (double)0.2, (double)0.8);
                double z = (double)pos.getZ() + Mth.nextDouble((RandomSource)level.random, (double)0.2, (double)0.8);
                double y = (double)pos.getY() + Mth.nextDouble((RandomSource)level.random, (double)0.8, (double)1.0);
                server.sendParticles((ParticleOptions)((SimpleParticleType)TFCParticles.SPARK.get()), x, y, z, 8, 0.0, 0.0, 0.0, (double)0.2f);
            }
            level.playSound(null, pos, SoundEvents.ANVIL_USE, SoundSource.PLAYERS, 0.6f, 1.0f);
        }
    }

    static {
        TYPE = PacketHandler.type("weld_button");
        CODEC = StreamCodec.unit((Object)((Object)PACKET));
    }
}

