/*
 * Decompiled with CFR 0.152.
 */
package net.litetex.authback.client.keys;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyPair;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.litetex.authback.client.keys.KeyPairReaderOrCreator;
import net.litetex.authback.client.keys.KeyState;
import net.litetex.authback.shared.json.JSONSerializer;
import net.minecraft.class_310;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientKeysManager {
    private static final Logger LOG = LoggerFactory.getLogger(ClientKeysManager.class);
    private final Path keyStatesFile;
    private KeyStates keyStates;
    private KeyPair keyPair;

    public ClientKeysManager(Path authbackDir) {
        this.keyStatesFile = authbackDir.resolve("key-states.json");
        CompletableFuture.runAsync(this::init);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        long startMs = System.currentTimeMillis();
        try {
            this.readKeyStatesFromFile();
            this.loadCurrentKeypair();
            this.saveKeyStatesFileAsync();
        }
        catch (Exception ex) {
            LOG.error("Initialization failed", (Throwable)ex);
        }
        finally {
            LOG.debug("Initialization finished, took {}ms", (Object)(System.currentTimeMillis() - startMs));
        }
    }

    public KeyPair currentKeyPair() {
        return Objects.requireNonNull(this.keyPair, "No keypair");
    }

    public void regenerate() {
        this.keyStates.getV1().remove(class_310.method_1551().method_1548().method_44717().toString());
        this.loadCurrentKeypair();
        this.saveKeyStatesFileAsync();
    }

    private void loadCurrentKeypair() {
        this.keyPair = new KeyPairReaderOrCreator(this.keyStates.getV1(), class_310.method_1551().method_1548().method_44717().toString()).getOrCreateKeyPair();
    }

    private void readKeyStatesFromFile() {
        if (!Files.exists(this.keyStatesFile, new LinkOption[0])) {
            this.keyStates = new KeyStates();
            return;
        }
        try {
            this.keyStates = (KeyStates)JSONSerializer.GSON.fromJson(Files.readString(this.keyStatesFile), KeyStates.class);
        }
        catch (Exception ex) {
            LOG.warn("Failed to read keyStatesFile['{}']", (Object)this.keyStatesFile, (Object)ex);
            this.keyStates = new KeyStates();
        }
    }

    private void saveKeyStatesFileAsync() {
        CompletableFuture.runAsync(this::saveKeyStatesFile);
    }

    private void saveKeyStatesFile() {
        try {
            Files.writeString(this.keyStatesFile, (CharSequence)JSONSerializer.GSON.toJson((Object)this.keyStates), new OpenOption[0]);
        }
        catch (Exception ex) {
            LOG.warn("Failed to write keyStatesFile['{}']", (Object)this.keyStatesFile, (Object)ex);
        }
    }

    static class KeyStates {
        private Map<String, KeyState> v1 = new HashMap<String, KeyState>();

        KeyStates() {
        }

        public Map<String, KeyState> getV1() {
            return this.v1;
        }

        public void setV1(Map<String, KeyState> v1) {
            this.v1 = v1;
        }
    }
}

