/*
 * Decompiled with CFR 0.152.
 */
package net.litetex.authback.client.keys;

import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.util.Map;
import net.litetex.authback.client.keys.KeyState;
import net.litetex.authback.shared.crypto.Ed25519KeyDecoder;
import net.litetex.authback.shared.crypto.Ed25519Signature;
import net.litetex.authback.shared.crypto.SecureRandomByteArrayCreator;
import net.litetex.authback.shared.external.org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KeyPairReaderOrCreator {
    private static final Logger LOG = LoggerFactory.getLogger(KeyPairReaderOrCreator.class);
    private final Map<String, KeyState> keyStates;
    private final String uuid;

    KeyPairReaderOrCreator(Map<String, KeyState> keyStates, String uuid) {
        this.keyStates = keyStates;
        this.uuid = uuid;
    }

    public KeyPair getOrCreateKeyPair() {
        KeyState keyState = this.keyStates.get(this.uuid);
        if (keyState == null) {
            return this.generate();
        }
        try {
            KeyPair keyPair = this.decode(keyState);
            this.keyStates.put(this.uuid, keyState.lastUsedNow());
            LOG.info("Successfully loaded for keypair[uuid={}] - Public Key: {}", (Object)this.uuid, (Object)keyState.publicKey());
            return keyPair;
        }
        catch (Exception ex) {
            LOG.warn("Failed to decode keys[uuid={}] - Regenerating them", (Object)this.uuid, (Object)ex);
            return this.generate();
        }
    }

    private KeyPair decode(KeyState keyState) throws Exception {
        Ed25519KeyDecoder keyDecoder = new Ed25519KeyDecoder();
        KeyPair keyPair = new KeyPair(keyDecoder.decodePublic(Hex.decodeHex(keyState.publicKey())), keyDecoder.decodePrivate(Hex.decodeHex(keyState.privateKey())));
        KeyPairReaderOrCreator.validateKeysMatch(keyPair);
        return keyPair;
    }

    private static void validateKeysMatch(KeyPair keyPair) {
        byte[] challenge = SecureRandomByteArrayCreator.create(4);
        if (!Ed25519Signature.isValidSignature(challenge, Ed25519Signature.createSignature(challenge, keyPair.getPrivate()), keyPair.getPublic())) {
            throw new IllegalStateException("Signature match failed");
        }
    }

    private KeyPair generate() {
        KeyPair keyPair = KeyPairReaderOrCreator.createKeyPairGenerator().generateKeyPair();
        Instant now = Instant.now();
        String publicKeyHex = Hex.encodeHexString(keyPair.getPublic().getEncoded());
        this.keyStates.put(this.uuid, new KeyState(Hex.encodeHexString(keyPair.getPrivate().getEncoded()), publicKeyHex, now, now));
        LOG.info("Generated new keypair - Public key: {}", (Object)publicKeyHex);
        return keyPair;
    }

    private static KeyPairGenerator createKeyPairGenerator() {
        try {
            return KeyPairGenerator.getInstance("Ed25519");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Failed to find ED25519 algorithm", e);
        }
    }
}

