/*
 * Decompiled with CFR 0.152.
 */
package net.litetex.authback.client.menu;

import java.util.List;
import java.util.stream.Stream;
import net.litetex.authback.client.AuthBackClient;
import net.litetex.authback.client.config.AuthBackClientConfig;
import net.litetex.authback.shared.config.ConfigValueContainer;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_350;
import net.minecraft.class_353;
import net.minecraft.class_364;
import net.minecraft.class_368;
import net.minecraft.class_370;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4667;
import net.minecraft.class_5676;
import net.minecraft.class_6379;
import net.minecraft.class_7842;
import net.minecraft.class_7919;

public class ConfigScreen
extends class_4667 {
    private final AuthBackClient abClient = AuthBackClient.instance();

    public ConfigScreen(class_437 screen, class_315 options) {
        super(screen, options, (class_2561)class_2561.method_43470((String)"AuthBack"));
    }

    protected void method_60325() {
        this.addKeyManagementOptions();
        this.addAPIInteractionOptions();
    }

    private void addKeyManagementOptions() {
        this.addCategory((class_2561)class_2561.method_43470((String)"Key Management"));
        this.field_51824.method_20407((class_339)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Copy public key"), ignored -> {
            this.field_22787.field_1774.method_1455(this.abClient.currentPublicKeyHex());
            this.showToast((class_2561)class_2561.method_43470((String)"Copied public key to clipboard"), 2000L);
        }).method_46431(), (class_339)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Regenerate keys"), ignored -> this.field_22787.method_1507((class_437)new class_410(yes -> {
            if (yes) {
                this.abClient.regenerateKeys();
                this.showToast((class_2561)class_2561.method_43470((String)"Regenerated keys"), 4000L);
            }
            this.field_22787.method_1507((class_437)this);
        }, (class_2561)class_2561.method_43470((String)"Confirm Regeneration"), (class_2561)class_2561.method_43470((String)"You should only regenerate your keys when your PRIVATE key got compromised.\nIn such a case you should also remove the key from existing servers using /authback public_keys remove self\n\nAlso note that servers will only be notified about your changed keys when you login to them again.\n\nContinue with regeneration?")))).method_46431());
    }

    private void addAPIInteractionOptions() {
        AuthBackClientConfig config = this.abClient.config();
        this.addCategory((class_2561)class_2561.method_43470((String)"API Interaction"));
        Stream.of(new BooleanConfigData(config.blockRealmsFetching(), "Block/Delay fetching initial Realms data", "Blocks initial fetching of Realms news, notifications, ..."), new BooleanConfigData(config.blockFetchingProfileKeys(), "Block fetching profile/chat-signing keys", "NOTE: You will NOT be able to join servers that have set enforce-secure-profile to true when this is enabled"), new BooleanConfigData(config.blockAddressCheck(), "Disable server address check", "Disables the central server blocklist lookup"), new BooleanConfigData(config.suppressAllServerJoinErrors(), "Suppress any joinServer error", "Blocks all errors encountered when calling joinServer.\nThis can work-around problems when the API is misbehaving and returning incorrect responses.\n\nWARNING: Allows joining servers with possibly invalid session data")).map(BooleanConfigData::createButton).map(btn -> new BigEntry(this.field_51824, (class_339)btn)).forEach(arg_0 -> ((class_353)this.field_51824).method_25321(arg_0));
    }

    private void addCategory(class_2561 category) {
        this.field_51824.method_25321((class_350.class_351)new CategoryEntry(this.field_51824, category));
    }

    private void showToast(class_2561 component, long displayTime) {
        this.field_22787.method_1566().method_1999((class_368)new class_370(new class_370.class_9037(displayTime), component, null));
    }

    record BooleanConfigData(ConfigValueContainer<Boolean> container, String name, String tooltip) {
        class_5676<Boolean> createButton() {
            return class_5676.method_32614((boolean)this.container.value()).method_32618(ignored -> class_7919.method_47407((class_2561)class_2561.method_43470((String)this.tooltip))).method_57720((class_2561)class_2561.method_43470((String)this.name), (btn, value) -> this.container.set((Boolean)value));
        }
    }

    static class CategoryEntry
    extends BigEntry {
        public CategoryEntry(class_353 list, class_2561 category) {
            super(list, (class_339)new class_7842(category, class_310.method_1551().field_1772));
        }

        @Override
        public void method_25343(class_332 guiGraphics, int i, int j, boolean bl, float f) {
            this.widget.method_48229(this.list.method_25368() / 2 - this.widget.method_25368() / 2, this.method_73386() - 12);
            this.widget.method_25394(guiGraphics, i, j, f);
        }
    }

    static class BigEntry
    extends class_353.class_354 {
        protected final class_353 list;
        protected final class_339 widget;

        public BigEntry(class_353 list, class_339 widget) {
            super(List.of(), null);
            this.list = list;
            this.widget = widget;
        }

        public void method_25343(class_332 guiGraphics, int i, int j, boolean bl, float f) {
            this.widget.method_25358(this.list.method_25322());
            this.widget.method_48229(this.list.field_49483.field_22789 / 2 - 155, this.method_73382());
            this.widget.method_25394(guiGraphics, i, j, f);
        }

        public List<? extends class_364> method_25396() {
            return List.of(this.widget);
        }

        public List<? extends class_6379> method_37025() {
            return List.of(this.widget);
        }
    }
}

