/*
 * Decompiled with CFR 0.152.
 */
package net.litetex.authback.client.network;

import io.netty.buffer.Unpooled;
import java.security.KeyPair;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.client.networking.v1.ClientConfigurationNetworking;
import net.fabricmc.fabric.api.client.networking.v1.ClientLoginNetworking;
import net.litetex.authback.client.keys.ClientKeysManager;
import net.litetex.authback.shared.crypto.Ed25519Signature;
import net.litetex.authback.shared.network.ChannelNames;
import net.litetex.authback.shared.network.configuration.ConfigurationRegistrySetup;
import net.litetex.authback.shared.network.configuration.SyncPayloadC2S;
import net.litetex.authback.shared.network.configuration.SyncPayloadS2C;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2817;
import net.minecraft.class_2960;
import net.minecraft.class_8710;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthBackClientNetworking {
    private static final Logger LOG = LoggerFactory.getLogger(AuthBackClientNetworking.class);
    private final ClientKeysManager clientKeysManager;

    public AuthBackClientNetworking(ClientKeysManager clientKeysManager) {
        this.clientKeysManager = clientKeysManager;
        this.setupProtoLogin();
        this.setupProtoConfiguration();
    }

    private void setupProtoLogin() {
        ClientLoginNetworking.registerGlobalReceiver((class_2960)ChannelNames.FALLBACK_AUTH, (client, handler, buf, callbacksConsumer) -> {
            LOG.info("Fallback auth request from server");
            byte[] challenge = buf.method_10795();
            KeyPair keyPair = this.clientKeysManager.currentKeyPair();
            class_2540 responseBuf = new class_2540(Unpooled.buffer());
            responseBuf.method_10813(Ed25519Signature.createSignature(challenge, keyPair.getPrivate()));
            responseBuf.method_10813(keyPair.getPublic().getEncoded());
            return CompletableFuture.completedFuture(responseBuf);
        });
    }

    private void setupProtoConfiguration() {
        ConfigurationRegistrySetup.setup();
        ClientConfigurationNetworking.registerGlobalReceiver(SyncPayloadS2C.ID, (payload, context) -> {
            if (!ClientConfigurationNetworking.canSend(SyncPayloadC2S.ID)) {
                LOG.debug("Unable to send {}", SyncPayloadC2S.ID);
                return;
            }
            LOG.info("Synchronizing with server");
            KeyPair keyPair = this.clientKeysManager.currentKeyPair();
            context.networkHandler().method_52787((class_2596)new class_2817((class_8710)new SyncPayloadC2S(Ed25519Signature.createSignature(payload.challenge(), keyPair.getPrivate()), keyPair.getPublic().getEncoded())));
        });
    }
}

