/*
 * Decompiled with CFR 0.152.
 */
package net.litetex.authback.common;

import com.mojang.authlib.minecraft.client.ObjectMapper;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.litetex.authback.shared.external.com.google.common.base.Suppliers;
import net.litetex.authback.shared.json.JSONSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalPublicKeysCache {
    private static final Logger LOG = LoggerFactory.getLogger(GlobalPublicKeysCache.class);
    private final ObjectMapper objectMapper = ObjectMapper.create();
    private final Path cacheFile;
    private final Optional<Duration> optDefaultReuseDuration;

    public GlobalPublicKeysCache(Path cacheFile, int defaultReuseMinutes) {
        this.cacheFile = cacheFile;
        this.optDefaultReuseDuration = defaultReuseMinutes > 0 ? Optional.of(Duration.ofMinutes(defaultReuseMinutes)) : Optional.empty();
    }

    public Optional<Duration> optDefaultReuseDuration() {
        return this.optDefaultReuseDuration;
    }

    public void saveAsync(URL url, Object response) {
        CompletableFuture.runAsync(() -> this.save(url, response));
    }

    private synchronized void save(URL url, Object response) {
        try {
            Files.writeString(this.cacheFile, (CharSequence)JSONSerializer.GSON.toJson((Object)new PersistentContainer(url.toString(), Instant.now(), this.objectMapper.writeValueAsString(response))), new OpenOption[0]);
        }
        catch (Exception e) {
            LOG.warn("Failed to save {}", (Object)this.cacheFile, (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Optional<CachedResponse<T>> read(URL url, Class<T> responseClass) {
        if (!Files.exists(this.cacheFile, new LinkOption[0])) {
            return Optional.empty();
        }
        long startMs = System.currentTimeMillis();
        try {
            PersistentContainer persistentContainer = (PersistentContainer)JSONSerializer.GSON.fromJson(Files.readString(this.cacheFile), PersistentContainer.class);
            if (!url.toString().equals(persistentContainer.url()) || persistentContainer.createdAt() == null || persistentContainer.createdAt().isAfter(Instant.now()) || persistentContainer.response() == null) {
                Optional<CachedResponse<T>> optional = Optional.empty();
                return optional;
            }
            Optional<CachedResponse<T>> optional = Optional.of(new CachedResponse<Object>(persistentContainer.createdAt(), Suppliers.memoize(() -> {
                long startMs2 = System.currentTimeMillis();
                try {
                    Object object = this.objectMapper.readValue(persistentContainer.response(), responseClass);
                    return object;
                }
                catch (Exception e2) {
                    LOG.warn("Failed to cached response", (Throwable)e2);
                    Object var6_6 = null;
                    return var6_6;
                }
                finally {
                    LOG.debug("Took {}ms to deserialize response", (Object)(System.currentTimeMillis() - startMs2));
                }
            })));
            return optional;
        }
        catch (Exception e) {
            LOG.warn("Failed to read {}", (Object)this.cacheFile, (Object)e);
            Optional<CachedResponse<T>> optional = Optional.empty();
            return optional;
        }
        finally {
            LOG.debug("Took {}ms to read and deserialize container", (Object)(System.currentTimeMillis() - startMs));
        }
    }

    record PersistentContainer(String url, Instant createdAt, String response) {
    }

    public record CachedResponse<T>(Instant createdAt, Supplier<T> reponseSupplier) {
        public Optional<T> response() {
            return Optional.ofNullable(this.reponseSupplier().get());
        }
    }
}

