/*
 * Decompiled with CFR 0.152.
 */
package net.litetex.authback.mixin.client;

import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.exceptions.AuthenticationUnavailableException;
import com.mojang.authlib.exceptions.ForcedUsernameChangeException;
import com.mojang.authlib.exceptions.InsufficientPrivilegesException;
import com.mojang.authlib.exceptions.InvalidCredentialsException;
import com.mojang.authlib.exceptions.UserBannedException;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import java.util.UUID;
import net.litetex.authback.client.AuthBackClient;
import net.minecraft.class_635;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={class_635.class})
public abstract class ClientHandshakePacketListenerImplMixin {
    @Unique
    private static final Logger LOG = LoggerFactory.getLogger(ClientHandshakePacketListenerImplMixin.class);

    @Redirect(method={"method_2892(Ljava/lang/String;)Lnet/minecraft/class_2561;"}, at=@At(value="INVOKE", target="Lcom/mojang/authlib/minecraft/MinecraftSessionService;joinServer(Ljava/util/UUID;Ljava/lang/String;Ljava/lang/String;)V"))
    private void redirectJoinServer(MinecraftSessionService sessionService, UUID uuid, String authToken, String serverId) throws AuthenticationException {
        try {
            sessionService.joinServer(uuid, authToken, serverId);
        }
        catch (AuthenticationUnavailableException ex) {
            LOG.warn("Authentication servers were unavailable while calling joinServer - Suppressing", (Throwable)ex);
        }
        catch (AuthenticationException ex) {
            if (!AuthBackClient.instance().config().suppressAllServerJoinErrors().value().booleanValue() && (ex instanceof InvalidCredentialsException || ex instanceof InsufficientPrivilegesException || ex instanceof ForcedUsernameChangeException || ex instanceof UserBannedException)) {
                throw ex;
            }
            LOG.warn("General exception while calling joinServer - Suppressing", (Throwable)ex);
        }
    }
}

