/*
 * Decompiled with CFR 0.152.
 */
package net.litetex.authback.mixin.common;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.HttpAuthenticationService;
import com.mojang.authlib.exceptions.MinecraftClientException;
import com.mojang.authlib.minecraft.client.MinecraftClient;
import com.mojang.authlib.yggdrasil.ProfileActionType;
import com.mojang.authlib.yggdrasil.ProfileResult;
import com.mojang.authlib.yggdrasil.YggdrasilMinecraftSessionService;
import com.mojang.authlib.yggdrasil.response.MinecraftProfilePropertiesResponse;
import com.mojang.authlib.yggdrasil.response.ProfileAction;
import com.mojang.util.UndashedUuid;
import java.net.URL;
import java.util.Set;
import java.util.UUID;
import net.litetex.authback.common.AuthBackCommon;
import net.litetex.authback.common.gameprofile.GameProfileCacheManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={YggdrasilMinecraftSessionService.class}, remap=false)
public abstract class YggdrasilMinecraftSessionServiceMixin {
    @Unique
    private static final Logger LOG = LoggerFactory.getLogger((String)"net.litetex.injected.YggdrasilMinecraftSessionService");
    @Final
    @Shadow
    private MinecraftClient client;
    @Final
    @Shadow
    private String baseUrl;

    @Shadow
    private static Set<ProfileActionType> extractProfileActionTypes(Set<ProfileAction> response) {
        return null;
    }

    @Inject(method={"fetchProfileUncached"}, at={@At(value="HEAD")}, cancellable=true)
    void fetchProfileUncached(UUID profileId, boolean requireSecure, CallbackInfoReturnable<ProfileResult> cir) {
        try {
            URL url = HttpAuthenticationService.concatenateURL((URL)HttpAuthenticationService.constantURL((String)(this.baseUrl + "profile/" + UndashedUuid.toString((UUID)profileId))), (String)("unsigned=" + !requireSecure));
            long startMs = System.currentTimeMillis();
            MinecraftProfilePropertiesResponse response = (MinecraftProfilePropertiesResponse)this.client.get(url, MinecraftProfilePropertiesResponse.class);
            LOG.debug("Took {}ms to get response for {}", (Object)(System.currentTimeMillis() - startMs), (Object)url);
            if (response == null) {
                LOG.debug("Couldn't fetch profile properties for {} as the profile does not exist", (Object)profileId);
                cir.setReturnValue(null);
                return;
            }
            GameProfile profile = response.profile();
            if (requireSecure) {
                this.gameProfileCacheManager().add(profile);
            }
            Set<ProfileActionType> profileActions = YggdrasilMinecraftSessionServiceMixin.extractProfileActionTypes(response.profileActions());
            LOG.trace("Successfully fetched profile properties for {}", (Object)profile);
            cir.setReturnValue((Object)new ProfileResult(profile, profileActions));
        }
        catch (MinecraftClientException | IllegalArgumentException e) {
            GameProfile cachedProfile;
            if (e instanceof MinecraftClientException && (cachedProfile = this.gameProfileCacheManager().findByUUID(profileId)) != null) {
                LOG.info("Failed to look up profile properties for {} but used cache instead", (Object)profileId, (Object)e);
                cir.setReturnValue((Object)new ProfileResult(cachedProfile, Set.of()));
                return;
            }
            LOG.warn("Couldn't look up profile properties for {}", (Object)profileId, (Object)e);
            cir.setReturnValue(null);
        }
    }

    @Unique
    private GameProfileCacheManager gameProfileCacheManager() {
        return AuthBackCommon.instance().gameProfileCacheManagerSupplier().get();
    }

    @Inject(method={"extractProfileActionTypes"}, at={@At(value="HEAD")}, cancellable=true)
    private static void extractProfileActionTypesInject(Set<ProfileAction> response, CallbackInfoReturnable<Set<ProfileActionType>> cir) {
        if (AuthBackCommon.instance().config().skipExtractProfileActionTypes().value().booleanValue()) {
            LOG.debug("Skipping execution of extractProfileActionTypes");
            cir.setReturnValue(Set.of());
        }
    }
}

