/*
 * Decompiled with CFR 0.152.
 */
package net.litetex.authback.mixin.common;

import com.mojang.authlib.exceptions.MinecraftClientException;
import com.mojang.authlib.minecraft.client.MinecraftClient;
import com.mojang.authlib.yggdrasil.YggdrasilServicesKeyInfo;
import java.net.URL;
import java.time.Instant;
import java.util.Optional;
import net.litetex.authback.common.AuthBackCommon;
import net.litetex.authback.common.GlobalPublicKeysCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={YggdrasilServicesKeyInfo.class}, remap=false)
public abstract class YggdrasilServicesKeyInfoMixin {
    @Unique
    private static final Logger LOG = LoggerFactory.getLogger(YggdrasilServicesKeyInfoMixin.class);

    @Redirect(method={"fetch"}, at=@At(value="INVOKE", target="Lcom/mojang/authlib/minecraft/client/MinecraftClient;get(Ljava/net/URL;Ljava/lang/Class;)Ljava/lang/Object;", remap=false), remap=false)
    private static <T> T get(MinecraftClient client, URL url, Class<T> responseClass) {
        try {
            GlobalPublicKeysCache globalPublicKeysCache = AuthBackCommon.instance().publicKeysCache();
            Optional<GlobalPublicKeysCache.CachedResponse<GlobalPublicKeysCache.CachedResponse>> optCachedResponse = globalPublicKeysCache.read(url, responseClass);
            return (T)optCachedResponse.filter(r -> globalPublicKeysCache.optDefaultReuseDuration().map(Instant.now()::minus).map(r.createdAt()::isAfter).orElse(false)).flatMap(GlobalPublicKeysCache.CachedResponse::response).map(YggdrasilServicesKeyInfoMixin::logUseCachedResponse).orElseGet(() -> {
                try {
                    long startMs = System.currentTimeMillis();
                    Object response = client.get(url, responseClass);
                    LOG.info("Took {}ms to get response for {}", (Object)(System.currentTimeMillis() - startMs), (Object)url.toString());
                    if (response == null) {
                        LOG.warn("Got empty response from server");
                        return optCachedResponse.flatMap(GlobalPublicKeysCache.CachedResponse::response).map(YggdrasilServicesKeyInfoMixin::logUseCachedResponse).orElse(null);
                    }
                    globalPublicKeysCache.saveAsync(url, response);
                    return response;
                }
                catch (MinecraftClientException ex) {
                    LOG.warn("Failed to get public key from servers", (Throwable)ex);
                    return optCachedResponse.flatMap(GlobalPublicKeysCache.CachedResponse::response).map(YggdrasilServicesKeyInfoMixin::logUseCachedResponse).orElseThrow(() -> ex);
                }
            });
        }
        catch (Exception ex) {
            LOG.error("Encountered general problem", (Throwable)ex);
            throw ex;
        }
    }

    @Unique
    private static <T> T logUseCachedResponse(T value) {
        LOG.info("Using cached response");
        return value;
    }
}

