/*
 * Decompiled with CFR 0.152.
 */
package net.litetex.authback.mixin.server;

import com.mojang.authlib.GameProfile;
import java.util.function.Consumer;
import net.litetex.authback.server.AuthBackServer;
import net.minecraft.class_2561;
import net.minecraft.class_3248;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(targets={"net/minecraft/class_3248$1"})
public abstract class ServerLoginPacketListenerImplUserAuthenticatorMixin {
    @Unique
    private static final Logger LOG = LoggerFactory.getLogger(ServerLoginPacketListenerImplUserAuthenticatorMixin.class);

    @Accessor(value="field_14176")
    abstract class_3248 serverLoginPacketListener();

    @Redirect(method={"run()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_3248;method_52417(Lcom/mojang/authlib/GameProfile;)V", ordinal=0))
    void handleHasJoinedSuccess(class_3248 instance, GameProfile gameProfile) {
        instance.method_52417(gameProfile);
        AuthBackServer.instance().handleJoinSuccess(gameProfile);
    }

    @Inject(method={"run()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_3248;method_14380(Lnet/minecraft/class_2561;)V", ordinal=0)}, cancellable=true)
    void handleNotJoined(CallbackInfo ci) {
        if (!AuthBackServer.instance().isAlwaysAllowFallbackAuth()) {
            LOG.debug("Always allow fallback auth is disabled");
            return;
        }
        this.doFallbackAuth("UnverifiedClient", loginPacketListener -> {
            loginPacketListener.method_14380((class_2561)class_2561.method_43471((String)"multiplayer.disconnect.unverified_username"));
            LOG.error("Couldn't verify username");
        });
        ci.cancel();
    }

    @Inject(method={"run()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_3248;method_14380(Lnet/minecraft/class_2561;)V", ordinal=1)}, cancellable=true)
    void handleAuthServersFailed(CallbackInfo ci) {
        this.doFallbackAuth("AuthServersDown", loginPacketListener -> {
            loginPacketListener.method_14380((class_2561)class_2561.method_43471((String)"multiplayer.disconnect.authservers_down"));
            LOG.error("Couldn't verify username because auth servers are unavailable");
        });
        ci.cancel();
    }

    @Unique
    private void doFallbackAuth(String variant, Consumer<class_3248> defaultDisconnectAction) {
        class_3248 loginPacketListener = this.serverLoginPacketListener();
        AuthBackServer.instance().doFallbackAuth(loginPacketListener, () -> defaultDisconnectAction.accept(loginPacketListener), msg -> {
            loginPacketListener.method_14380((class_2561)class_2561.method_43470((String)("[AuthBack] " + msg)));
            LOG.info("[AuthBack/{}] Disconnected client: {}", (Object)variant, msg);
        }, gameProfile -> {
            loginPacketListener.method_52417(gameProfile);
            LOG.info("[AuthBack/{}] Fallback was successful - Proceeding with login of player[name={},uuid={}]", new Object[]{variant, gameProfile.name(), gameProfile.id()});
        });
    }
}

