/*
 * Decompiled with CFR 0.152.
 */
package net.litetex.authback.server;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.litetex.authback.common.AuthBackCommon;
import net.litetex.authback.common.gameprofile.GameProfileCacheManager;
import net.litetex.authback.server.command.FallbackCommand;
import net.litetex.authback.server.fallbackauth.FallbackAuthRateLimiter;
import net.litetex.authback.server.fallbackauth.FallbackUserAuthenticationAdapter;
import net.litetex.authback.server.keys.ServerProfilePublicKeysManager;
import net.litetex.authback.server.network.AuthBackServerNetworking;
import net.litetex.authback.shared.AuthBack;
import net.litetex.authback.shared.external.com.google.common.base.Suppliers;
import net.minecraft.class_2168;
import net.minecraft.class_2535;
import net.minecraft.class_3248;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthBackServer
extends AuthBack {
    private static final Logger LOG = LoggerFactory.getLogger(AuthBackServer.class);
    private static AuthBackServer instance;
    private final Supplier<ServerProfilePublicKeysManager> serverProfilePublicKeysManagerSupplier;
    private final Supplier<GameProfileCacheManager> gameProfileCacheManagerSupplier;
    private final FallbackUserAuthenticationAdapter fallbackUserAuthenticationAdapter;
    private final Set<class_2535> connectionsToSkipUpToDateCheck = Collections.synchronizedSet(Collections.newSetFromMap(new WeakHashMap()));
    private final boolean alwaysAllowFallbackAuth;
    private final boolean skipOldUserConversion;

    public static AuthBackServer instance() {
        return instance;
    }

    public static void setInstance(AuthBackServer instance) {
        AuthBackServer.instance = instance;
    }

    public AuthBackServer() {
        super("server");
        CompletableFuture<ServerProfilePublicKeysManager> cfServerProfilePublicKeysManager = CompletableFuture.supplyAsync(() -> new ServerProfilePublicKeysManager(this.authbackDir.resolve("profiles-public-keys.json"), this.lowLevelConfig.getInteger("keys.max-keys-per-player", 3), Duration.ofDays(this.lowLevelConfig.getInteger("keys.delete-after-unused-days", 36))));
        this.serverProfilePublicKeysManagerSupplier = Suppliers.memoize(cfServerProfilePublicKeysManager::join);
        this.gameProfileCacheManagerSupplier = AuthBackCommon.instance().gameProfileCacheManagerSupplier();
        this.fallbackUserAuthenticationAdapter = new FallbackUserAuthenticationAdapter(this.serverProfilePublicKeysManagerSupplier, this.gameProfileCacheManagerSupplier, FallbackAuthRateLimiter.create(this.lowLevelConfig));
        this.alwaysAllowFallbackAuth = this.lowLevelConfig.getBoolean("fallback-auth.allow-always", true);
        this.skipOldUserConversion = this.lowLevelConfig.getBoolean("skip-old-user-conversion", true);
        new AuthBackServerNetworking(this.connectionsToSkipUpToDateCheck, this.serverProfilePublicKeysManagerSupplier);
        CommandRegistrationCallback.EVENT.register((dispatcher, buildContext, selection) -> new FallbackCommand(this.serverProfilePublicKeysManagerSupplier, this.gameProfileCacheManagerSupplier).register((CommandDispatcher<class_2168>)dispatcher));
        LOG.debug("Initialized");
    }

    public void handleJoinSuccess(GameProfile profile) {
        this.gameProfileCacheManagerSupplier.get().add(profile);
    }

    public void doFallbackAuth(class_3248 loginPacketListener, Runnable defaultAction, Consumer<String> customDisconnectAction, Consumer<GameProfile> successAction) {
        this.fallbackUserAuthenticationAdapter.doFallbackAuth(loginPacketListener, defaultAction, customDisconnectAction, profile -> {
            this.connectionsToSkipUpToDateCheck.add(loginPacketListener.field_14158);
            successAction.accept((GameProfile)profile);
        });
    }

    public boolean isAlwaysAllowFallbackAuth() {
        return this.alwaysAllowFallbackAuth;
    }

    public boolean isSkipOldUserConversion() {
        return this.skipOldUserConversion;
    }
}

