/*
 * Decompiled with CFR 0.152.
 */
package net.litetex.authback.server.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.security.PublicKey;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.litetex.authback.common.gameprofile.GameProfileCacheManager;
import net.litetex.authback.server.keys.ServerProfilePublicKeysManager;
import net.litetex.authback.shared.crypto.Ed25519KeyDecoder;
import net.litetex.authback.shared.external.org.apache.commons.codec.binary.Hex;
import net.minecraft.class_11560;
import net.minecraft.class_12090;
import net.minecraft.class_12095;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_5242;
import net.minecraft.class_5250;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FallbackCommand {
    private static final Logger LOG = LoggerFactory.getLogger(FallbackCommand.class);
    private static final DateTimeFormatter INSTANT_BASIC_DATE_TIME = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm").withZone(ZoneId.systemDefault());
    private final Supplier<ServerProfilePublicKeysManager> serverProfilePublicKeysManagerSupplier;
    private final Supplier<GameProfileCacheManager> gameProfileCacheManagerSupplier;

    public FallbackCommand(Supplier<ServerProfilePublicKeysManager> serverProfilePublicKeysManagerSupplier, Supplier<GameProfileCacheManager> gameProfileCacheManagerSupplier) {
        this.serverProfilePublicKeysManagerSupplier = serverProfilePublicKeysManagerSupplier;
        this.gameProfileCacheManagerSupplier = gameProfileCacheManagerSupplier;
    }

    private ServerProfilePublicKeysManager serverProfilePublicKeysManager() {
        return this.serverProfilePublicKeysManagerSupplier.get();
    }

    private GameProfileCacheManager gameProfileCacheManager() {
        return this.gameProfileCacheManagerSupplier.get();
    }

    public void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"authback").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"public_key").then(this.registerAdd())).then(this.registerRemove())).then(this.registerList())));
    }

    private LiteralArgumentBuilder<class_2168> registerAdd() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"add").requires(FallbackCommand.permissionAdmin())).then(FallbackCommand.cmdId().then(FallbackCommand.cmdArgId().suggests((ctx, builder) -> class_2172.method_9264(this.gameProfileCacheManager().uuids().stream().map(UUID::toString), (SuggestionsBuilder)builder)).then(FallbackCommand.cmdArgPKH().executes(ctx -> this.execAdd((CommandContext<class_2168>)ctx, FallbackCommand.resolveArgId((CommandContext<class_2168>)ctx), FallbackCommand.resolveArgPKH((CommandContext<class_2168>)ctx))))))).then(FallbackCommand.cmdName().then(FallbackCommand.cmdArgName().suggests((ctx, builder) -> class_2172.method_9265(this.gameProfileCacheManager().names(), (SuggestionsBuilder)builder)).then(FallbackCommand.cmdArgPKH().executes(ctx -> this.execAdd((CommandContext<class_2168>)ctx, FallbackCommand.resolveArgName((CommandContext<class_2168>)ctx), FallbackCommand.resolveArgPKH((CommandContext<class_2168>)ctx))))));
    }

    private int execAdd(CommandContext<class_2168> ctx, String name, String publicKeyHex) {
        return this.execForName(ctx, name, uuid -> this.execAdd(ctx, (UUID)uuid, publicKeyHex));
    }

    private int execAdd(CommandContext<class_2168> ctx, UUID uuid, String publicKeyHex) {
        PublicKey publicKey;
        byte[] encodedKeyData;
        try {
            encodedKeyData = Hex.decodeHex(publicKeyHex);
            publicKey = new Ed25519KeyDecoder().decodePublic(encodedKeyData);
        }
        catch (Exception ex) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)("Failed to decode public key: " + ex.getMessage())));
            LOG.debug("Failed to decode public key", (Throwable)ex);
            return 0;
        }
        this.serverProfilePublicKeysManager().add(uuid, encodedKeyData, publicKey);
        class_5250 root = class_2561.method_43473().method_27693("Add public key for ").method_10852(this.renderPlayer(ctx, uuid));
        ((class_2168)ctx.getSource()).method_9226(() -> root, false);
        return 1;
    }

    private LiteralArgumentBuilder<class_2168> registerRemove() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"remove").then(((LiteralArgumentBuilder)FallbackCommand.cmdSelf().then(FallbackCommand.cmdAll().executes(this::execRemoveAllSelf))).then(FallbackCommand.cmdArgPKH().executes(ctx -> this.execRemoveSelf((CommandContext<class_2168>)ctx, FallbackCommand.resolveArgPKH((CommandContext<class_2168>)ctx)))))).then(((LiteralArgumentBuilder)FallbackCommand.cmdId().requires(FallbackCommand.permissionAdmin())).then(((RequiredArgumentBuilder)FallbackCommand.cmdArgId().suggests(this.suggestExistingPublicKeyUserUUIDs()).then(FallbackCommand.cmdAll().executes(ctx -> this.execRemoveAll((CommandContext<class_2168>)ctx, FallbackCommand.resolveArgId((CommandContext<class_2168>)ctx))))).then(FallbackCommand.cmdArgPKH().executes(ctx -> this.execRemove((CommandContext<class_2168>)ctx, FallbackCommand.resolveArgId((CommandContext<class_2168>)ctx), FallbackCommand.resolveArgPKH((CommandContext<class_2168>)ctx))))))).then(((LiteralArgumentBuilder)FallbackCommand.cmdName().requires(FallbackCommand.permissionAdmin())).then(((RequiredArgumentBuilder)FallbackCommand.cmdArgName().suggests(this.suggestExistingPublicKeyUserNames()).then(FallbackCommand.cmdAll().executes(ctx -> this.execRemoveAll((CommandContext<class_2168>)ctx, FallbackCommand.resolveArgName((CommandContext<class_2168>)ctx))))).then(FallbackCommand.cmdArgPKH().executes(ctx -> this.execRemove((CommandContext<class_2168>)ctx, FallbackCommand.resolveArgName((CommandContext<class_2168>)ctx), FallbackCommand.resolveArgPKH((CommandContext<class_2168>)ctx))))));
    }

    private int execRemoveSelf(CommandContext<class_2168> ctx, String publicKeyHex) throws CommandSyntaxException {
        return this.execRemove(ctx, FallbackCommand.uuidFromCtx(ctx), publicKeyHex);
    }

    private int execRemove(CommandContext<class_2168> ctx, String name, String publicKeyHex) {
        return this.execForName(ctx, name, uuid -> this.execRemove(ctx, (UUID)uuid, publicKeyHex));
    }

    private int execRemove(CommandContext<class_2168> ctx, UUID uuid, String publicKeyHex) {
        if (this.serverProfilePublicKeysManager().remove(uuid, publicKeyHex)) {
            class_5250 root = class_2561.method_43473().method_27693("Removed public key from ").method_10852(this.renderPlayer(ctx, uuid));
            ((class_2168)ctx.getSource()).method_9226(() -> root, false);
            return 1;
        }
        ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43473().method_27693("Failed to find public key for ").method_10852(this.renderPlayer(ctx, uuid)));
        return 0;
    }

    private int execRemoveAllSelf(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        return this.execRemoveAll(ctx, FallbackCommand.uuidFromCtx(ctx));
    }

    private int execRemoveAll(CommandContext<class_2168> ctx, String name) {
        return this.execForName(ctx, name, uuid -> this.execRemoveAll(ctx, (UUID)uuid));
    }

    private int execRemoveAll(CommandContext<class_2168> ctx, UUID uuid) {
        int keyCount = this.serverProfilePublicKeysManager().removeAll(uuid);
        class_5250 root = class_2561.method_43473().method_27693("Removed " + keyCount + " public key(s) from ").method_10852(this.renderPlayer(ctx, uuid));
        ((class_2168)ctx.getSource()).method_9226(() -> root, false);
        return 1;
    }

    private LiteralArgumentBuilder<class_2168> registerList() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"list").then(FallbackCommand.cmdSelf().executes(this::execListSelf))).then(((LiteralArgumentBuilder)FallbackCommand.cmdAll().requires(FallbackCommand.permissionAdmin())).executes(this::execListAll))).then(((LiteralArgumentBuilder)FallbackCommand.cmdId().requires(FallbackCommand.permissionAdmin())).then(FallbackCommand.cmdArgId().suggests(this.suggestExistingPublicKeyUserUUIDs()).executes(ctx -> this.execList((CommandContext<class_2168>)ctx, FallbackCommand.resolveArgId((CommandContext<class_2168>)ctx)))))).then(((LiteralArgumentBuilder)FallbackCommand.cmdName().requires(FallbackCommand.permissionAdmin())).then(FallbackCommand.cmdArgName().suggests(this.suggestExistingPublicKeyUserNames()).executes(ctx -> this.execList((CommandContext<class_2168>)ctx, FallbackCommand.resolveArgName((CommandContext<class_2168>)ctx)))));
    }

    private int execListSelf(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        return this.execList(ctx, FallbackCommand.uuidFromCtx(ctx));
    }

    private int execListAll(CommandContext<class_2168> ctx) {
        return this.execListing(ctx, this.serverProfilePublicKeysManager().uuidPublicKeyHex());
    }

    private int execList(CommandContext<class_2168> ctx, String name) {
        return this.execForName(ctx, name, uuid -> this.execList(ctx, (UUID)uuid));
    }

    private int execList(CommandContext<class_2168> ctx, UUID uuid) {
        return this.execListing(ctx, Optional.ofNullable(this.serverProfilePublicKeysManager().uuidPublicKeyHex().get(uuid)).map(val -> Map.of(uuid, val)).orElseGet(Map::of));
    }

    private int execListing(CommandContext<class_2168> ctx, Map<UUID, List<ServerProfilePublicKeysManager.PublicKeyInfo>> uuidPublicKeysHex) {
        class_5250 root = class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)("Listing " + uuidPublicKeysHex.size() + " player(s) with " + uuidPublicKeysHex.values().stream().mapToInt(List::size).sum() + " public key(s)")).method_27694(style -> style.method_10978(Boolean.valueOf(true)).method_10977(class_124.field_1080)));
        uuidPublicKeysHex.entrySet().stream().flatMap(e -> Stream.concat(Stream.of(this.renderPlayer(ctx, (UUID)e.getKey())), ((List)e.getValue()).stream().map(pki -> Stream.of(class_2561.method_43470((String)"- "), class_2561.method_43470((String)(pki.hex().substring(0, 16) + "...")).method_27694(style -> style.method_10978(Boolean.valueOf(true)).method_10958((class_2558)new class_2558.class_10606(pki.hex())).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)pki.hex())))), class_2561.method_43470((String)" "), class_2561.method_43470((String)INSTANT_BASIC_DATE_TIME.format(pki.lastUse())).method_27694(style -> style.method_10958((class_2558)new class_2558.class_10606(pki.lastUse().toString())).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)("Last used: " + String.valueOf(pki.lastUse()))))))).reduce(class_2561.method_43473(), class_5250::method_10852)))).forEach(c -> root.method_27693("\n").method_10852(c));
        ((class_2168)ctx.getSource()).method_9226(() -> root, false);
        return 1;
    }

    private class_2561 renderPlayer(CommandContext<class_2168> ctx, UUID uuid) {
        return class_2561.method_43470((String)this.associatedNameOrUUID(ctx, uuid)).method_27694(style -> style.method_10958((class_2558)new class_2558.class_10606(uuid.toString())).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)uuid.toString()))));
    }

    private String associatedNameOrUUID(CommandContext<class_2168> ctx, UUID uuid) {
        return this.findNameForUUID(ctx, uuid).orElseGet(uuid::toString);
    }

    private int execForName(CommandContext<class_2168> ctx, String name, Function<UUID, Integer> func) {
        return this.findUUIDByName(ctx, name).map(func).orElseGet(() -> {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Failed to resolve player for name"));
            return 0;
        });
    }

    private SuggestionProvider<class_2168> suggestExistingPublicKeyUserUUIDs() {
        return (ctx, builder) -> class_2172.method_9264(this.serverProfilePublicKeysManager().profileUUIDs().stream().map(UUID::toString).sorted(), (SuggestionsBuilder)builder);
    }

    private SuggestionProvider<class_2168> suggestExistingPublicKeyUserNames() {
        return (ctx, builder) -> class_2172.method_9264(this.serverProfilePublicKeysManager().profileUUIDs().stream().map(uuid -> this.findNameForUUID((CommandContext<class_2168>)ctx, (UUID)uuid)).filter(Optional::isPresent).map(Optional::get).sorted(), (SuggestionsBuilder)builder);
    }

    private Optional<String> findNameForUUID(CommandContext<class_2168> ctx, UUID uuid) {
        return ((class_2168)ctx.getSource()).method_9211().method_73550().comp_4407().method_14512(uuid).map(class_11560::comp_4423);
    }

    private Optional<UUID> findUUIDByName(CommandContext<class_2168> ctx, String name) {
        return ((class_2168)ctx.getSource()).method_9211().method_73550().comp_4407().method_14515(name).map(class_11560::comp_4422);
    }

    private static UUID uuidFromCtx(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        return ((class_2168)ctx.getSource()).method_9207().method_72498().comp_4422();
    }

    private static LiteralArgumentBuilder<class_2168> cmdAll() {
        return class_2170.method_9247((String)"*");
    }

    private static LiteralArgumentBuilder<class_2168> cmdName() {
        return class_2170.method_9247((String)"name");
    }

    private static LiteralArgumentBuilder<class_2168> cmdId() {
        return class_2170.method_9247((String)"id");
    }

    private static LiteralArgumentBuilder<class_2168> cmdSelf() {
        return class_2170.method_9247((String)"self");
    }

    private static String resolveArgName(CommandContext<class_2168> ctx) {
        return StringArgumentType.getString(ctx, (String)"name");
    }

    private static RequiredArgumentBuilder<class_2168, String> cmdArgName() {
        return class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word());
    }

    private static UUID resolveArgId(CommandContext<class_2168> ctx) {
        return class_5242.method_27645(ctx, (String)"id");
    }

    private static RequiredArgumentBuilder<class_2168, UUID> cmdArgId() {
        return class_2170.method_9244((String)"id", (ArgumentType)class_5242.method_27643());
    }

    private static String resolveArgPKH(CommandContext<class_2168> ctx) {
        return StringArgumentType.getString(ctx, (String)"publicKeyHex");
    }

    private static RequiredArgumentBuilder<class_2168, String> cmdArgPKH() {
        return class_2170.method_9244((String)"publicKeyHex", (ArgumentType)StringArgumentType.word());
    }

    private static class_12095<class_2168> permissionAdmin() {
        return class_2170.method_71774((class_12090)class_2170.field_31840);
    }
}

