/*
 * Decompiled with CFR 0.152.
 */
package net.litetex.authback.server.fallbackauth;

import com.google.common.util.concurrent.RateLimiter;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.litetex.authback.shared.collections.MaxSizedHashMap;
import net.litetex.authback.shared.config.Configuration;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FallbackAuthRateLimiter {
    private static final Logger LOG = LoggerFactory.getLogger(FallbackAuthRateLimiter.class);
    private final Map<RateLimitKey, RateLimiter> rateLimiters;
    private final Supplier<RateLimiter> newRateLimiterSupplier;
    private final boolean ignoreLocalAddresses;
    private final int ipv6NetworkPrefixBytes;

    FallbackAuthRateLimiter(int requestPerMinutePerIP, int bucketSize, boolean ignoreLocalAddresses, int ipv6NetworkPrefixBytes) {
        this.rateLimiters = Collections.synchronizedMap(new MaxSizedHashMap(bucketSize));
        this.newRateLimiterSupplier = () -> RateLimiter.create((double)((double)requestPerMinutePerIP / 60.0));
        this.ignoreLocalAddresses = ignoreLocalAddresses;
        if (ipv6NetworkPrefixBytes < 0 || ipv6NetworkPrefixBytes > 16) {
            throw new IllegalArgumentException("ipv6NetworkPrefixBytes=" + ipv6NetworkPrefixBytes + " out of bound[min=0,max=16]");
        }
        this.ipv6NetworkPrefixBytes = ipv6NetworkPrefixBytes;
    }

    @Nullable
    public static FallbackAuthRateLimiter create(Configuration config) {
        String prefix = "fallback-auth.rate-limit.";
        int requestsPerMinutePerIP = config.getInteger("fallback-auth.rate-limit.requests-per-ip-per-minute", 20);
        if (requestsPerMinutePerIP <= 0) {
            return null;
        }
        return new FallbackAuthRateLimiter(requestsPerMinutePerIP, config.getInteger("fallback-auth.rate-limit.bucket-size", 1000), config.getBoolean("fallback-auth.rate-limit.ignore-private-addresses", true), config.getInteger("fallback-auth.rate-limit.ipv6-network-prefix-bytes", 8));
    }

    public boolean isAddressRateLimited(InetAddress address) {
        if (this.ignoreLocalAddresses && (address.isLoopbackAddress() || address.isLinkLocalAddress() || address.isSiteLocalAddress())) {
            LOG.debug("Will not rate limit local address: {}", (Object)address);
            return false;
        }
        return !this.rateLimiters.computeIfAbsent(RateLimitKey.create(address, this.ipv6NetworkPrefixBytes), ignored -> this.newRateLimiterSupplier.get()).tryAcquire();
    }

    record RateLimitKey(IPVersion version, byte[] addressBytes) {
        public static RateLimitKey create(InetAddress address, int ipv6NetworkPrefixBytes) {
            if (address instanceof Inet6Address) {
                Inet6Address inet6Address = (Inet6Address)address;
                return new RateLimitKey(IPVersion.V6, Arrays.copyOfRange(inet6Address.getAddress(), 0, ipv6NetworkPrefixBytes));
            }
            return new RateLimitKey(IPVersion.V4, address.getAddress());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object o) {
            IPVersion otherVersion;
            Object object;
            if (!(o instanceof RateLimitKey)) return false;
            RateLimitKey rateLimitKey = (RateLimitKey)o;
            try {
                otherVersion = object = rateLimitKey.version();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            Object otherAddressBytes = object = (Object)rateLimitKey.addressBytes();
            if (this.version() != otherVersion) return false;
            if (!Arrays.equals(this.addressBytes(), (byte[])otherAddressBytes)) return false;
            return true;
        }

        @Override
        public int hashCode() {
            return 31 * Objects.hashCode((Object)this.version()) + Arrays.hashCode(this.addressBytes());
        }
    }

    static enum IPVersion {
        V4,
        V6;

    }
}

