/*
 * Decompiled with CFR 0.152.
 */
package net.litetex.authback.server.fallbackauth;

import com.mojang.authlib.GameProfile;
import io.netty.buffer.Unpooled;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.PublicKey;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.networking.v1.ServerLoginNetworking;
import net.fabricmc.fabric.impl.networking.server.ServerNetworkingImpl;
import net.litetex.authback.common.gameprofile.GameProfileCacheManager;
import net.litetex.authback.server.fallbackauth.FallbackAuthRateLimiter;
import net.litetex.authback.server.keys.ServerProfilePublicKeysManager;
import net.litetex.authback.shared.crypto.Ed25519Signature;
import net.litetex.authback.shared.crypto.SecureRandomByteArrayCreator;
import net.litetex.authback.shared.network.ChannelNames;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3248;
import net.minecraft.class_3544;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FallbackUserAuthenticationAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(FallbackUserAuthenticationAdapter.class);
    private final Supplier<ServerProfilePublicKeysManager> serverProfilePublicKeysManagerSupplier;
    private final Supplier<GameProfileCacheManager> gameProfileCacheManagerSupplier;
    @Nullable
    private final FallbackAuthRateLimiter rateLimiter;

    public FallbackUserAuthenticationAdapter(Supplier<ServerProfilePublicKeysManager> serverProfilePublicKeysManagerSupplier, Supplier<GameProfileCacheManager> gameProfileCacheManagerSupplier, @Nullable FallbackAuthRateLimiter rateLimiter) {
        this.serverProfilePublicKeysManagerSupplier = serverProfilePublicKeysManagerSupplier;
        this.gameProfileCacheManagerSupplier = gameProfileCacheManagerSupplier;
        this.rateLimiter = rateLimiter;
    }

    private ServerProfilePublicKeysManager serverProfilePublicKeysManager() {
        return this.serverProfilePublicKeysManagerSupplier.get();
    }

    private GameProfileCacheManager gameProfileCacheManager() {
        return this.gameProfileCacheManagerSupplier.get();
    }

    public void doFallbackAuth(class_3248 loginPacketListener, Runnable defaultAction, Consumer<String> customDisconnectAction, Consumer<GameProfile> successAction) {
        try {
            this.handleFallbackAuthS2C(loginPacketListener, defaultAction, customDisconnectAction, successAction);
        }
        catch (Exception ex) {
            LOG.error("Unexpected error during fallback auth S2C process", (Throwable)ex);
            customDisconnectAction.accept("Internal fallback error");
        }
    }

    private void handleFallbackAuthS2C(class_3248 loginPacketListener, Runnable defaultAction, Consumer<String> customDisconnectAction, Consumer<GameProfile> successAction) {
        if (this.rateLimitExceeded(loginPacketListener, defaultAction, customDisconnectAction)) {
            return;
        }
        String requestedUsername = loginPacketListener.field_45028;
        LOG.info("Trying fallback auth for username={}", (Object)requestedUsername);
        if (requestedUsername == null || !class_3544.method_57179((String)requestedUsername)) {
            LOG.info("Aborting due to invalid username={}", (Object)requestedUsername);
            defaultAction.run();
            return;
        }
        GameProfile gameProfile = this.getGameProfileFor(loginPacketListener, requestedUsername);
        if (gameProfile == null) {
            LOG.info("Unable to find matching profile for username={}", (Object)requestedUsername);
            defaultAction.run();
            return;
        }
        if (!this.serverProfilePublicKeysManager().hasAnyKeyQuickCheck(gameProfile.id())) {
            LOG.info("No public key for {}", (Object)gameProfile.id());
            defaultAction.run();
            return;
        }
        byte[] challenge = SecureRandomByteArrayCreator.create(4);
        class_2540 requestBuf = new class_2540(Unpooled.buffer());
        requestBuf.method_10813(challenge);
        ServerLoginNetworking.registerReceiver((class_3248)loginPacketListener, (class_2960)ChannelNames.FALLBACK_AUTH, (server, handler, understood, buf, synchronizer, responseSender) -> {
            if (!understood) {
                LOG.info("Client[id={}] did not understand fallback auth - disconnecting", (Object)gameProfile.id());
                defaultAction.run();
                return;
            }
            try {
                this.handleFallbackAuthC2S(customDisconnectAction, successAction, buf, gameProfile, challenge);
            }
            catch (Exception ex) {
                LOG.error("Unexpected error during fallback auth C2S process", (Throwable)ex);
                customDisconnectAction.accept("Internal fallback error");
            }
        });
        ServerNetworkingImpl.getAddon((class_3248)loginPacketListener).sendPacket(ChannelNames.FALLBACK_AUTH, requestBuf);
    }

    private GameProfile getGameProfileFor(class_3248 loginPacketListener, String requestedUsername) {
        GameProfile profile = this.gameProfileCacheManager().findByName(requestedUsername);
        if (profile != null) {
            return profile;
        }
        LOG.debug("Failed to find internally cached game profile[name={}], trying nameToIdCache", (Object)requestedUsername);
        return loginPacketListener.field_14162.method_73550().comp_4407().method_14515(requestedUsername).map(nameAndId -> {
            LOG.warn("Failed to find cached game profile[name={}], but was able to use nameToIdCache. Creating temporary profile[uuid={}] without profile properties!", (Object)requestedUsername, (Object)nameAndId.comp_4422());
            return new GameProfile(nameAndId.comp_4422(), nameAndId.comp_4423());
        }).orElse(null);
    }

    private boolean rateLimitExceeded(class_3248 loginPacketListener, Runnable defaultAction, Consumer<String> customDisconnectAction) {
        if (this.rateLimiter == null) {
            return false;
        }
        SocketAddress remoteSocketAddress = loginPacketListener.field_14158.method_10755();
        if (!(remoteSocketAddress instanceof InetSocketAddress)) {
            LOG.warn("Failed handle type of remoteAddress {}", (Object)remoteSocketAddress);
            defaultAction.run();
            return true;
        }
        InetSocketAddress inetSocketAddr = (InetSocketAddress)remoteSocketAddress;
        InetAddress address = inetSocketAddr.getAddress();
        if (this.rateLimiter.isAddressRateLimited(address)) {
            LOG.debug("Address exceeded rate limit: {}", (Object)address);
            customDisconnectAction.accept("Too many requests");
            return true;
        }
        return false;
    }

    private void handleFallbackAuthC2S(Consumer<String> customDisconnectAction, Consumer<GameProfile> successAction, class_2540 buf, GameProfile gameProfile, byte[] challenge) {
        byte[] signature = buf.method_10795();
        byte[] publicKeyEncoded = buf.method_10795();
        PublicKey publicKey = this.serverProfilePublicKeysManager().find(gameProfile.id(), publicKeyEncoded);
        if (publicKey == null) {
            customDisconnectAction.accept("Received invalid public key");
            return;
        }
        if (!Ed25519Signature.isValidSignature(challenge, signature, publicKey)) {
            customDisconnectAction.accept("Received invalid signature");
            return;
        }
        successAction.accept(gameProfile);
    }
}

