/*
 * Decompiled with CFR 0.152.
 */
package net.litetex.authback.server.keys;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.PublicKey;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.litetex.authback.shared.collections.AdvancedCollectors;
import net.litetex.authback.shared.crypto.Ed25519KeyDecoder;
import net.litetex.authback.shared.external.com.google.common.base.Suppliers;
import net.litetex.authback.shared.external.org.apache.commons.codec.DecoderException;
import net.litetex.authback.shared.external.org.apache.commons.codec.binary.Hex;
import net.litetex.authback.shared.json.JSONSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerProfilePublicKeysManager {
    private static final Logger LOG = LoggerFactory.getLogger(ServerProfilePublicKeysManager.class);
    private static final Duration DELETE_AFTER_UNUSED_EXECUTION_INTERVAL = Duration.ofHours(12L);
    private final Path file;
    private final int maxKeysPerUser;
    private final Duration deleteAfterUnused;
    private Instant nextDeleteAfterUnusedExecutionTime = Instant.now().plus(DELETE_AFTER_UNUSED_EXECUTION_INTERVAL);
    private Map<UUID, Map<Integer, KeyInfo>> profileUUIDKeys = new HashMap<UUID, Map<Integer, KeyInfo>>();

    public ServerProfilePublicKeysManager(Path file, int maxKeysPerUser, Duration deleteAfterUnused) {
        this.file = file;
        this.maxKeysPerUser = maxKeysPerUser;
        this.deleteAfterUnused = deleteAfterUnused;
        this.readFile();
    }

    public void add(UUID uuid, byte[] encodedPublicKey, PublicKey publicKey) {
        Map publicKeys = this.profileUUIDKeys.computeIfAbsent(uuid, ignored -> Collections.synchronizedMap(new LinkedHashMap()));
        int hash = Arrays.hashCode(encodedPublicKey);
        Instant now = Instant.now();
        KeyInfo keyInfo = publicKeys.computeIfAbsent(hash, ignored -> new KeyInfo(encodedPublicKey, () -> publicKey, now));
        if (keyInfo.lastUsedAt() != now) {
            publicKeys.put(hash, keyInfo.updateLastUsedAt(now));
        }
        if (publicKeys.size() > this.maxKeysPerUser) {
            Comparator<Map.Entry> comparator = Comparator.comparing(e -> ((KeyInfo)e.getValue()).lastUsedAt()).reversed();
            publicKeys.entrySet().stream().sorted(comparator).skip(this.maxKeysPerUser).map(Map.Entry::getKey).toList().forEach(publicKeys::remove);
        }
        this.saveAsync();
    }

    public boolean hasAnyKeyQuickCheck(UUID profileUUID) {
        return this.profileUUIDKeys.get(profileUUID) != null;
    }

    public PublicKey find(UUID profileUUID, byte[] encodedPublicKey) {
        Map<Integer, KeyInfo> keyInfos = this.profileUUIDKeys.get(profileUUID);
        if (keyInfos == null) {
            return null;
        }
        this.cleanUpIfRequired();
        int hashedPublicKey = Arrays.hashCode(encodedPublicKey);
        KeyInfo keyInfo = keyInfos.get(hashedPublicKey);
        if (keyInfo == null) {
            return null;
        }
        try {
            return keyInfo.publicKeySupplier().get();
        }
        catch (Exception ex) {
            LOG.warn("Failed to deserialize public key", (Throwable)ex);
            keyInfos.remove(hashedPublicKey);
            if (keyInfos.isEmpty()) {
                this.profileUUIDKeys.remove(profileUUID);
            }
            return null;
        }
    }

    public int removeAll(UUID uuid) {
        Map<Integer, KeyInfo> keyInfos = this.profileUUIDKeys.remove(uuid);
        if (keyInfos == null) {
            return 0;
        }
        this.saveAsync();
        return keyInfos.size();
    }

    public boolean remove(UUID uuid, String publicKeyEncoded) {
        Map<Integer, KeyInfo> keyInfos = this.profileUUIDKeys.get(uuid);
        if (keyInfos == null) {
            return false;
        }
        try {
            if (keyInfos.remove(Arrays.hashCode(Hex.decodeHex(publicKeyEncoded))) == null) {
                return false;
            }
        }
        catch (DecoderException dex) {
            return false;
        }
        if (keyInfos.isEmpty()) {
            this.profileUUIDKeys.remove(uuid);
        }
        this.saveAsync();
        return true;
    }

    public Set<UUID> profileUUIDs() {
        return new HashSet<UUID>(this.profileUUIDKeys.keySet());
    }

    public Map<UUID, List<PublicKeyInfo>> uuidPublicKeyHex() {
        return this.profileUUIDKeys.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Map)e.getValue()).values().stream().map(k -> new PublicKeyInfo(Hex.encodeHexString(k.publicKeyEncoded()), k.lastUsedAt())).sorted(Comparator.comparing(PublicKeyInfo::lastUse)).toList()));
    }

    private synchronized void cleanUpIfRequired() {
        Instant now = Instant.now();
        if (this.nextDeleteAfterUnusedExecutionTime.isBefore(now)) {
            this.nextDeleteAfterUnusedExecutionTime = now.plus(DELETE_AFTER_UNUSED_EXECUTION_INTERVAL);
            Instant deleteBefore = now.minus(this.deleteAfterUnused);
            this.profileUUIDKeys.values().forEach(publicKeys -> publicKeys.entrySet().stream().filter(e -> ((KeyInfo)e.getValue()).lastUsedAt().isBefore(deleteBefore)).map(Map.Entry::getKey).toList().forEach(publicKeys::remove));
            this.profileUUIDKeys.entrySet().stream().filter(e -> ((Map)e.getValue()).isEmpty()).map(Map.Entry::getKey).toList().forEach(this.profileUUIDKeys::remove);
        }
    }

    private void readFile() {
        if (!Files.exists(this.file, new LinkOption[0])) {
            return;
        }
        long startMs = System.currentTimeMillis();
        try {
            Instant deleteBefore = Instant.now().minus(this.deleteAfterUnused);
            PersistentState persistentState = (PersistentState)JSONSerializer.GSON.fromJson(Files.readString(this.file), PersistentState.class);
            this.profileUUIDKeys = Collections.synchronizedMap(persistentState.ensureProfileUUIDKeys().entrySet().stream().filter(e -> e.getValue() != null).collect(AdvancedCollectors.toLinkedHashMap(e -> UUID.fromString((String)e.getKey()), e -> Collections.synchronizedMap(((Set)e.getValue()).stream().filter(e2 -> e2.lastUsedAt().isAfter(deleteBefore)).map(e2 -> {
                try {
                    return Map.entry(Hex.decodeHex(e2.publicKey()), e2);
                }
                catch (DecoderException ex) {
                    LOG.warn("Failed to decode public key from file", (Throwable)ex);
                    return null;
                }
            }).filter(Objects::nonNull).collect(AdvancedCollectors.toLinkedHashMap(e3 -> Arrays.hashCode((byte[])e3.getKey()), e3 -> new KeyInfo((byte[])e3.getKey(), Suppliers.memoize(() -> new Ed25519KeyDecoder().decodePublic((byte[])e3.getKey())), ((PersistentState.PersistentKeyInfo)e3.getValue()).lastUsedAt())))))));
            LOG.debug("Took {}ms to read keys for {}x profiles", (Object)(System.currentTimeMillis() - startMs), (Object)this.profileUUIDKeys.size());
        }
        catch (Exception ex) {
            LOG.warn("Failed to read file['{}']", (Object)this.file, (Object)ex);
        }
    }

    private void saveAsync() {
        CompletableFuture.runAsync(this::saveToFile);
    }

    private synchronized void saveToFile() {
        long startMs = System.currentTimeMillis();
        this.cleanUpIfRequired();
        try {
            PersistentState persistentState = new PersistentState((Map<String, Set<PersistentState.PersistentKeyInfo>>)this.profileUUIDKeys.entrySet().stream().collect(AdvancedCollectors.toLinkedHashMap(e -> ((UUID)e.getKey()).toString(), e -> ((Map)e.getValue()).values().stream().map(KeyInfo::persist).collect(Collectors.toCollection(LinkedHashSet::new)))));
            Files.writeString(this.file, (CharSequence)JSONSerializer.GSON.toJson((Object)persistentState), new OpenOption[0]);
            LOG.debug("Took {}ms to write keys for {}x profiles", (Object)(System.currentTimeMillis() - startMs), (Object)this.profileUUIDKeys.size());
        }
        catch (Exception ex) {
            LOG.warn("Failed to write file['{}']", (Object)this.file, (Object)ex);
        }
    }

    record KeyInfo(byte[] publicKeyEncoded, Supplier<PublicKey> publicKeySupplier, Instant lastUsedAt) {
        public KeyInfo updateLastUsedAt(Instant now) {
            return new KeyInfo(this.publicKeyEncoded(), this.publicKeySupplier(), now);
        }

        public PersistentState.PersistentKeyInfo persist() {
            return new PersistentState.PersistentKeyInfo(Hex.encodeHexString(this.publicKeyEncoded()), this.lastUsedAt());
        }
    }

    record PersistentState(Map<String, Set<PersistentKeyInfo>> profileUUIDKeys) {
        Map<String, Set<PersistentKeyInfo>> ensureProfileUUIDKeys() {
            return this.profileUUIDKeys != null ? this.profileUUIDKeys : Map.of();
        }

        record PersistentKeyInfo(String publicKey, Instant lastUsedAt) {
        }
    }

    public record PublicKeyInfo(String hex, Instant lastUse) {
    }
}

