/*
 * Decompiled with CFR 0.152.
 */
package net.litetex.authback.server.network;

import com.mojang.authlib.GameProfile;
import java.security.PublicKey;
import java.util.Set;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationNetworking;
import net.litetex.authback.server.keys.ServerProfilePublicKeysManager;
import net.litetex.authback.shared.crypto.Ed25519KeyDecoder;
import net.litetex.authback.shared.crypto.Ed25519Signature;
import net.litetex.authback.shared.crypto.SecureRandomByteArrayCreator;
import net.litetex.authback.shared.network.configuration.ConfigurationRegistrySetup;
import net.litetex.authback.shared.network.configuration.SyncPayloadC2S;
import net.litetex.authback.shared.network.configuration.SyncPayloadS2C;
import net.minecraft.class_2535;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_8610;
import net.minecraft.class_8710;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthBackServerNetworking {
    private static final Logger LOG = LoggerFactory.getLogger(AuthBackServerNetworking.class);
    private final Set<class_2535> connectionsToSkipUpToDateCheck;
    private final Supplier<ServerProfilePublicKeysManager> serverProfilePublicKeysManagerSupplier;

    public AuthBackServerNetworking(Set<class_2535> connectionsToSkipUpToDateCheck, Supplier<ServerProfilePublicKeysManager> serverProfilePublicKeysManagerSupplier) {
        this.connectionsToSkipUpToDateCheck = connectionsToSkipUpToDateCheck;
        this.serverProfilePublicKeysManagerSupplier = serverProfilePublicKeysManagerSupplier;
        this.setupProtoConfiguration();
    }

    private ServerProfilePublicKeysManager serverProfilePublicKeysManager() {
        return this.serverProfilePublicKeysManagerSupplier.get();
    }

    private void setupProtoConfiguration() {
        ConfigurationRegistrySetup.setup();
        ServerConfigurationConnectionEvents.CONFIGURE.register((handler, server) -> {
            GameProfile profile = handler.method_52404();
            if (this.connectionsToSkipUpToDateCheck.remove(handler.field_45013)) {
                LOG.debug("Skipping up-to-date check for {}", (Object)profile.id());
                return;
            }
            if (!ServerConfigurationNetworking.canSend((class_8610)handler, SyncPayloadS2C.ID)) {
                LOG.debug("Unable to send {} to {}", SyncPayloadS2C.ID, (Object)profile.id());
                return;
            }
            byte[] challenge = SecureRandomByteArrayCreator.create(4);
            this.registerUpToDateCheckPacketReceiver(handler, challenge, profile);
            handler.method_14364((class_2596)new class_2658((class_8710)new SyncPayloadS2C(challenge)));
        });
    }

    private void registerUpToDateCheckPacketReceiver(class_8610 originalHandler, byte[] challenge, GameProfile profile) {
        ServerConfigurationNetworking.registerReceiver((class_8610)originalHandler, SyncPayloadC2S.ID, (payload, context) -> {
            PublicKey publicKey = new Ed25519KeyDecoder().decodePublic(payload.publicKey());
            if (!Ed25519Signature.isValidSignature(challenge, payload.signature(), publicKey)) {
                LOG.debug("Received invalid signature from {}", (Object)profile.id());
                return;
            }
            this.serverProfilePublicKeysManager().add(profile.id(), payload.publicKey(), publicKey);
        });
    }
}

