/*
 * Decompiled with CFR 0.152.
 */
package net.litetex.authback.shared.config;

import java.util.Objects;
import net.litetex.authback.shared.config.Configuration;
import org.apache.commons.lang3.function.TriConsumer;
import org.apache.commons.lang3.function.TriFunction;

public class ConfigValueContainer<T> {
    private final Configuration config;
    private final String path;
    private final T defaultValue;
    private final TriConsumer<Configuration, String, T> setIntoConfig;
    private T value;

    public ConfigValueContainer(Configuration config, String path, T defaultValue, TriFunction<Configuration, String, T, T> getFromConfig, TriConsumer<Configuration, String, T> setIntoConfig) {
        this.config = config;
        this.path = path;
        this.defaultValue = defaultValue;
        this.setIntoConfig = setIntoConfig;
        this.value = getFromConfig.apply((Object)config, (Object)path, defaultValue);
    }

    public static ConfigValueContainer<Boolean> bool(Configuration config, String path, boolean defaultValue) {
        return new ConfigValueContainer<Boolean>(config, path, defaultValue, Configuration::getBoolean, Configuration::setBoolean);
    }

    public T value() {
        return this.value;
    }

    public void set(T value) {
        this.value = value;
        if (Objects.equals(this.defaultValue, value)) {
            this.config.remove(this.path);
        } else {
            this.setIntoConfig.accept((Object)this.config, (Object)this.path, value);
        }
        this.config.save();
    }
}

