/*
 * Decompiled with CFR 0.152.
 */
package net.litetex.authback.shared.config;

import java.util.List;
import net.litetex.authback.shared.config.Configuration;

public abstract class RuntimeConfiguration
implements Configuration {
    public static RuntimeConfiguration environmentVariables(final String prefix) {
        return new RuntimeConfiguration(){

            @Override
            public String getString(String path, String def) {
                String name = prefix + "_" + path.replace(".", "_").replace("-", "_").toUpperCase();
                String value = System.getenv(name);
                return value != null ? value : def;
            }
        };
    }

    public static RuntimeConfiguration systemProperties(final String prefix) {
        return new RuntimeConfiguration(){

            @Override
            public String getString(String path, String def) {
                return System.getProperty(prefix + "." + path, def);
            }
        };
    }

    @Override
    public boolean getBoolean(String path, boolean def) {
        return Boolean.parseBoolean(this.getString(path, Boolean.toString(def)));
    }

    @Override
    public int getInteger(String path, int def) {
        try {
            return Integer.parseInt(this.getString(path, Integer.toString(def)));
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    @Override
    public List<String> getStringList(String path) {
        String value = this.getString(path, "");
        return value.isEmpty() ? List.of() : List.of(value.split(","));
    }

    @Override
    public boolean contains(String path) {
        return this.getString(path, null) != null;
    }

    @Override
    public void load() {
    }

    @Override
    public void save() {
    }

    @Override
    public void setString(String path, String value) {
    }

    @Override
    public void setBoolean(String path, boolean value) {
    }

    @Override
    public void setInteger(String path, int value) {
    }

    @Override
    public void setStringList(String path, List<String> value) {
    }

    @Override
    public void remove(String path) {
    }
}

