/*
 * Decompiled with CFR 0.152.
 */
package net.litetex.authback.shared.crypto;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;

public final class Ed25519Signature {
    public static byte[] createSignature(byte[] data, PrivateKey privateKey) {
        try {
            Signature signature = Ed25519Signature.createSignature();
            signature.initSign(privateKey);
            signature.update(data);
            return signature.sign();
        }
        catch (InvalidKeyException | SignatureException e) {
            throw new IllegalStateException("Failed to create signature", e);
        }
    }

    public static boolean isValidSignature(byte[] data, byte[] signatureBytes, PublicKey publicKey) {
        try {
            Signature signature = Ed25519Signature.createSignature();
            signature.initVerify(publicKey);
            signature.update(data);
            return signature.verify(signatureBytes);
        }
        catch (InvalidKeyException | SignatureException e) {
            throw new IllegalStateException("Failed to verify signature", e);
        }
    }

    private static Signature createSignature() {
        try {
            return Signature.getInstance("Ed25519");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Failed to find ED25519 algorithm", e);
        }
    }

    private Ed25519Signature() {
    }
}

