/*
 * Decompiled with CFR 0.152.
 */
package net.litetex.authback.shared.external.com.google.common.base;

import java.util.Objects;
import java.util.function.Supplier;

public final class Suppliers {
    private Suppliers() {
    }

    public static <T> Supplier<T> memoize(Supplier<T> delegate) {
        if (delegate instanceof NonSerializableMemoizingSupplier) {
            return delegate;
        }
        return new NonSerializableMemoizingSupplier<T>(delegate);
    }

    static class NonSerializableMemoizingSupplier<T>
    implements Supplier<T> {
        private final Object lock = new Object();
        private static final Supplier<Void> SUCCESSFULLY_COMPUTED = () -> {
            throw new IllegalStateException();
        };
        private volatile Supplier<T> delegate;
        private T value;

        NonSerializableMemoizingSupplier(Supplier<T> delegate) {
            this.delegate = Objects.requireNonNull(delegate);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get() {
            if (this.delegate != SUCCESSFULLY_COMPUTED) {
                Object object = this.lock;
                synchronized (object) {
                    if (this.delegate != SUCCESSFULLY_COMPUTED) {
                        T t = this.delegate.get();
                        this.value = t;
                        this.delegate = SUCCESSFULLY_COMPUTED;
                        return t;
                    }
                }
            }
            return this.value;
        }

        public String toString() {
            Supplier<T> delegate = this.delegate;
            return "Suppliers.memoize(" + String.valueOf(delegate == SUCCESSFULLY_COMPUTED ? "<supplier that returned " + String.valueOf(this.value) + ">" : delegate) + ")";
        }
    }
}

