/*
 * Decompiled with CFR 0.152.
 */
package net.litetex.authback.shared.io;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import net.litetex.authback.shared.config.Configuration;

public final class AuthBackDirEnsurer {
    public static Path ensureAuthbackDir(Configuration config, String variant) {
        Path dir = Optional.ofNullable(config.getString("dir", null)).map(x$0 -> Paths.get(x$0, new String[0])).orElseGet(() -> FabricLoader.getInstance().getGameDir().resolve(".authback").resolve(variant));
        if (!Files.exists(dir, new LinkOption[0])) {
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return dir;
    }

    private AuthBackDirEnsurer() {
    }
}

