/*
 * Decompiled with CFR 0.152.
 */
package net.litetex.authback.shared.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.time.Instant;
import java.time.format.DateTimeFormatter;

public final class JSONSerializer {
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(Instant.class, (Object)new InstantConverter()).setPrettyPrinting().create();

    private JSONSerializer() {
    }

    static class InstantConverter
    implements JsonSerializer<Instant>,
    JsonDeserializer<Instant> {
        public static final DateTimeFormatter FORMATTER = DateTimeFormatter.ISO_INSTANT;

        InstantConverter() {
        }

        public JsonElement serialize(Instant src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(FORMATTER.format(src));
        }

        public Instant deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
            return FORMATTER.parse((CharSequence)json.getAsString(), Instant::from);
        }
    }
}

