/*
 * Decompiled with CFR 0.152.
 */
package com.araxer.araxers_bestiary.client;

import com.araxer.araxers_bestiary.config.Config;
import com.araxer.araxers_bestiary.data.RankUtils;
import com.mojang.logging.LogUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ClientProgressionData {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Map<EntityType<?>, Integer> killCounts = new HashMap();
    private static final Map<EntityType<?>, String> entityRanks = new HashMap();
    private static final Map<EntityType<?>, Boolean> newlyDiscoveredEntities = new HashMap();
    private static final Map<EntityType<?>, Boolean> spyglassObservedEntities = new HashMap();
    private static final Map<EntityType<?>, Boolean> fullyDiscoveredEntities = new HashMap();
    private static final Map<EntityType<?>, Integer> rankXPoints = new HashMap();
    private static final Map<EntityType<?>, Integer> rankXDaysSinceS = new HashMap();
    private static final Map<EntityType<?>, Integer> rankXSessionsSinceS = new HashMap();
    private static final Map<EntityType<?>, Map<String, Integer>> rankXChallengeAwarded = new HashMap();
    private static final Map<EntityType<?>, Integer> esPoints = new HashMap();
    private static final Map<EntityType<?>, Integer> esThresholds = new HashMap();

    public static void updateKillCount(EntityType<?> entityType, int killCount) {
        killCounts.put(entityType, killCount);
        LOGGER.debug("Updated client-side kill count for {}: {}", (Object)entityType.m_20675_(), (Object)killCount);
    }

    public static void updateRank(EntityType<?> entityType, String rank) {
        if (!RankUtils.isValidRank(rank)) {
            LOGGER.warn("Attempted to set invalid rank {} for entity {}", (Object)rank, (Object)entityType.m_20675_());
            return;
        }
        String oldRank = entityRanks.getOrDefault(entityType, "");
        entityRanks.put(entityType, rank);
        LOGGER.debug("Updated client-side rank for {}: {} -> {}", new Object[]{entityType.m_20675_(), oldRank, rank});
    }

    public static int getKillCount(EntityType<?> entityType) {
        return killCounts.getOrDefault(entityType, 0);
    }

    public static String getRank(EntityType<?> entityType) {
        return entityRanks.getOrDefault(entityType, "");
    }

    public static boolean hasReachedThreshold(EntityType<?> entityType, int threshold) {
        return ClientProgressionData.getKillCount(entityType) >= threshold;
    }

    public static boolean meetsRankThreshold(EntityType<?> entityType, String thresholdRank) {
        String rank = ClientProgressionData.getRank(entityType);
        return RankUtils.meetsRankThreshold(rank, thresholdRank);
    }

    public static void updateESProgress(EntityType<?> entityType, int points, int threshold) {
        esPoints.put(entityType, points);
        esThresholds.put(entityType, threshold);
        LOGGER.debug("Updated ES progress for {}: {}/{}", new Object[]{entityType.m_20675_(), points, threshold});
    }

    public static int getESPoints(EntityType<?> entityType) {
        return esPoints.getOrDefault(entityType, 0);
    }

    public static int getESThreshold(EntityType<?> entityType) {
        return esThresholds.getOrDefault(entityType, 0);
    }

    public static boolean shouldShowSpawnLocations(EntityType<?> entityType) {
        if (!Config.enableProgressionSystem) {
            return true;
        }
        if ("sighting".equals(Config.progressionSystemType)) {
            return true;
        }
        if ("kills".equals(Config.progressionSystemType)) {
            return ClientProgressionData.hasReachedThreshold(entityType, Config.spawnLocationThreshold);
        }
        return ClientProgressionData.meetsRankThreshold(entityType, Config.spawnLocationRank);
    }

    public static boolean shouldShowLootIcons(EntityType<?> entityType) {
        if (!Config.enableProgressionSystem) {
            return true;
        }
        if ("sighting".equals(Config.progressionSystemType)) {
            return true;
        }
        if ("kills".equals(Config.progressionSystemType)) {
            return ClientProgressionData.hasReachedThreshold(entityType, Config.lootIconThreshold);
        }
        return ClientProgressionData.meetsRankThreshold(entityType, Config.lootIconRank);
    }

    public static boolean shouldShowLootChances(EntityType<?> entityType) {
        if (!Config.enableProgressionSystem) {
            return true;
        }
        if ("sighting".equals(Config.progressionSystemType)) {
            return true;
        }
        if ("kills".equals(Config.progressionSystemType)) {
            return ClientProgressionData.hasReachedThreshold(entityType, Config.lootChanceThreshold);
        }
        return ClientProgressionData.meetsRankThreshold(entityType, Config.lootChanceRank);
    }

    public static boolean shouldShowAdvancedAttributes(EntityType<?> entityType) {
        if (!Config.enableProgressionSystem) {
            return true;
        }
        if ("sighting".equals(Config.progressionSystemType)) {
            return true;
        }
        if ("kills".equals(Config.progressionSystemType)) {
            return ClientProgressionData.hasReachedThreshold(entityType, Config.advancedAttributesThreshold);
        }
        return ClientProgressionData.meetsRankThreshold(entityType, Config.advancedAttributesRank);
    }

    public static boolean shouldShowDescription(EntityType<?> entityType) {
        if (!Config.enableProgressionSystem) {
            return true;
        }
        if ("sighting".equals(Config.progressionSystemType)) {
            return true;
        }
        if ("kills".equals(Config.progressionSystemType)) {
            return ClientProgressionData.hasReachedThreshold(entityType, Config.descriptionThreshold);
        }
        return ClientProgressionData.meetsRankThreshold(entityType, Config.descriptionRank);
    }

    public static void updateNewlyDiscoveredStatus(EntityType<?> entityType, boolean isNew) {
        newlyDiscoveredEntities.put(entityType, isNew);
        LOGGER.debug("Updated client-side newly discovered status for {}: {}", (Object)entityType.m_20675_(), (Object)isNew);
    }

    public static boolean isNewlyDiscovered(EntityType<?> entityType) {
        return newlyDiscoveredEntities.getOrDefault(entityType, false);
    }

    public static void updateSpyglassObservedStatus(EntityType<?> entityType, boolean isObserved) {
        spyglassObservedEntities.put(entityType, isObserved);
        LOGGER.debug("Updated client-side spyglass observed status for {}: {}", (Object)entityType.m_20675_(), (Object)isObserved);
    }

    public static boolean isSpyglassObserved(EntityType<?> entityType) {
        return spyglassObservedEntities.getOrDefault(entityType, false);
    }

    public static void updateFullyDiscoveredStatus(EntityType<?> entityType, boolean isDiscovered) {
        fullyDiscoveredEntities.put(entityType, isDiscovered);
        LOGGER.debug("Updated client-side fully discovered status for {}: {}", (Object)entityType.m_20675_(), (Object)isDiscovered);
    }

    public static boolean isFullyDiscovered(EntityType<?> entityType) {
        return fullyDiscoveredEntities.getOrDefault(entityType, false);
    }

    public static boolean isPartiallyDiscovered(EntityType<?> entityType) {
        String rank;
        if ("sighting".equals(Config.progressionSystemType)) {
            return false;
        }
        if (ClientProgressionData.isFullyDiscovered(entityType)) {
            return false;
        }
        if ("ranks".equals(Config.progressionSystemType) && !(rank = ClientProgressionData.getRank(entityType)).equals("")) {
            return false;
        }
        return ClientProgressionData.isSpyglassObserved(entityType) && ClientProgressionData.getKillCount(entityType) == 0;
    }

    public static void markAsViewed(EntityType<?> entityType) {
        LOGGER.debug("Marking entity {} as viewed", (Object)entityType.m_20675_());
        boolean wasNew = newlyDiscoveredEntities.getOrDefault(entityType, false);
        if (!wasNew) {
            LOGGER.debug("Entity {} was already marked as viewed", (Object)entityType.m_20675_());
            return;
        }
        newlyDiscoveredEntities.put(entityType, false);
        LOGGER.debug("Successfully marked entity {} as viewed on client side", (Object)entityType.m_20675_());
    }

    public static int getRankXPoints(EntityType<?> entityType) {
        return rankXPoints.getOrDefault(entityType, 0);
    }

    public static int getRankXDaysSinceS(EntityType<?> entityType) {
        return rankXDaysSinceS.getOrDefault(entityType, -1);
    }

    public static int getRankXSessionsSinceS(EntityType<?> entityType) {
        return rankXSessionsSinceS.getOrDefault(entityType, 0);
    }

    public static Map<String, Integer> getRankXChallengeProgress(EntityType<?> entityType) {
        return rankXChallengeAwarded.getOrDefault(entityType, Collections.emptyMap());
    }

    public static void updateRankXProgress(EntityType<?> entityType, int points, int daysSinceS, int sessions, Map<String, Integer> perChallenge) {
        rankXPoints.put(entityType, points);
        rankXDaysSinceS.put(entityType, daysSinceS);
        rankXSessionsSinceS.put(entityType, sessions);
        if (perChallenge != null) {
            rankXChallengeAwarded.put(entityType, new HashMap<String, Integer>(perChallenge));
        }
        LOGGER.debug("Updated client Rank-X for {}: pts={}, daysSinceS={}, sessions={}, challenges={}", new Object[]{entityType.m_20675_(), points, daysSinceS, sessions, perChallenge != null ? perChallenge.size() : 0});
    }

    public static void clear() {
        LOGGER.debug("Clearing all client-side data...");
        int killCountSize = killCounts.size();
        int rankSize = entityRanks.size();
        int viewedCount = 0;
        for (Boolean isNew : newlyDiscoveredEntities.values()) {
            if (isNew.booleanValue()) continue;
            ++viewedCount;
        }
        int observedCount = (int)spyglassObservedEntities.values().stream().filter(Boolean::booleanValue).count();
        int fullyDiscoveredCount = (int)fullyDiscoveredEntities.values().stream().filter(Boolean::booleanValue).count();
        LOGGER.debug("Clearing {} kill counts, {} ranks, {} viewed entities, {} observed entities, and {} fully discovered entities", new Object[]{killCountSize, rankSize, viewedCount, observedCount, fullyDiscoveredCount});
        killCounts.clear();
        entityRanks.clear();
        newlyDiscoveredEntities.clear();
        spyglassObservedEntities.clear();
        fullyDiscoveredEntities.clear();
        LOGGER.debug("Successfully cleared all client-side data");
        rankXPoints.clear();
        rankXDaysSinceS.clear();
        rankXSessionsSinceS.clear();
        rankXChallengeAwarded.clear();
        esPoints.clear();
        esThresholds.clear();
    }
}

