/*
 * Decompiled with CFR 0.152.
 */
package com.araxer.araxers_bestiary.client;

import com.araxer.araxers_bestiary.client.KeyBindings;
import com.araxer.araxers_bestiary.client.PacketHandler;
import com.araxer.araxers_bestiary.client.gui.BestiaryScreen;
import com.araxer.araxers_bestiary.network.CommonPacketHandler;
import com.mojang.logging.LogUtils;
import net.minecraft.client.Minecraft;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="araxers_bestiary", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientSetup {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static void registerConfigScreen() {
        LOGGER.info("Registering config screen factory");
        ModLoadingContext.get().registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((mc, previousScreen) -> new BestiaryScreen()));
    }

    public static void init(FMLClientSetupEvent event) {
        LOGGER.info("Initializing client-side components");
        LOGGER.info("MINECRAFT NAME >> {}", (Object)Minecraft.m_91087_().m_91094_().m_92546_());
        event.enqueueWork(() -> {
            try {
                if (CommonPacketHandler.TOAST_CHANNEL == null) {
                    LOGGER.warn("CommonPacketHandler channels are not initialized yet. This might cause issues.");
                    LOGGER.warn("Ensure CommonPacketHandler.init() is called before ClientSetup.init()");
                }
                KeyBindings.init();
                PacketHandler.init();
                LOGGER.info("Initialized client-side packet handlers");
            }
            catch (Exception e) {
                LOGGER.error("Error during client initialization: {}", (Object)e.getMessage(), (Object)e);
            }
        });
    }

    @SubscribeEvent
    public static void onRegisterKeyMappings(RegisterKeyMappingsEvent event) {
        KeyBindings.registerKeys(event);
    }
}

