/*
 * Decompiled with CFR 0.152.
 */
package com.araxer.araxers_bestiary.data;

import com.araxer.araxers_bestiary.data.LootItemEntry;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.slf4j.Logger;

@Mod.EventBusSubscriber(modid="araxers_bestiary", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class BestiaryLootManager
extends SimpleJsonResourceReloadListener {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final String FOLDER_PATH = "bestiary";
    private static Map<EntityType<?>, List<LootItemEntry>> lootMap = new HashMap();
    private static Map<EntityType<?>, Boolean> lootOverrideMap = new HashMap();

    public BestiaryLootManager() {
        super(GSON, FOLDER_PATH);
    }

    @SubscribeEvent
    public static void onResourceReload(AddReloadListenerEvent event) {
        BestiaryLootManager manager = new BestiaryLootManager();
        event.addListener((PreparableReloadListener)manager);
        LOGGER.debug("Registered bestiary loot manager as resource reload listener on thread: {} for side: {}", (Object)Thread.currentThread().getName(), (Object)event.getClass().getClassLoader().toString());
        LOGGER.debug("Current lootMap size before reload: {}", (Object)lootMap.size());
        for (Map.Entry<EntityType<?>, List<LootItemEntry>> entry : lootMap.entrySet()) {
            ResourceLocation entityId = ForgeRegistries.ENTITY_TYPES.getKey(entry.getKey());
            LOGGER.debug("LootMap contains entity {} with {} loot entries", (Object)entityId, (Object)entry.getValue().size());
        }
    }

    public static List<LootItemEntry> getLootForEntity(EntityType<?> entityType) {
        ResourceLocation entityId = ForgeRegistries.ENTITY_TYPES.getKey(entityType);
        List<LootItemEntry> loot = lootMap.get(entityType);
        if (loot != null) {
            LOGGER.debug("Found {} loot entries for entity {} in lootMap", (Object)loot.size(), (Object)entityId);
        } else {
            LOGGER.debug("No loot entries found for entity {} in lootMap", (Object)entityId);
        }
        return loot;
    }

    public static boolean hasLootForEntity(EntityType<?> entityType) {
        ResourceLocation entityId = ForgeRegistries.ENTITY_TYPES.getKey(entityType);
        List<LootItemEntry> loot = lootMap.get(entityType);
        boolean hasLoot = loot != null && !loot.isEmpty();
        LOGGER.debug("Checking if entity {} has loot: {}", (Object)entityId, (Object)hasLoot);
        return hasLoot;
    }

    public static boolean isLootOverrideEnabled(EntityType<?> entityType) {
        if (lootOverrideMap.containsKey(entityType) && lootOverrideMap.get(entityType).booleanValue()) {
            LOGGER.debug("Found global loot override flag for entity: {}", (Object)ForgeRegistries.ENTITY_TYPES.getKey(entityType));
            return true;
        }
        List<LootItemEntry> lootEntries = BestiaryLootManager.getLootForEntity(entityType);
        if (lootEntries == null || lootEntries.isEmpty()) {
            return false;
        }
        for (LootItemEntry entry : lootEntries) {
            if (!entry.override()) continue;
            LOGGER.debug("Found loot entry with override flag for entity: {}", (Object)ForgeRegistries.ENTITY_TYPES.getKey(entityType));
            return true;
        }
        return false;
    }

    protected void apply(Map<ResourceLocation, JsonElement> resourceMap, ResourceManager resourceManager, ProfilerFiller profiler) {
        LOGGER.debug("Loading bestiary loot data from data packs on thread: {}", (Object)Thread.currentThread().getName());
        LOGGER.info("Resource map contains {} entries", (Object)resourceMap.size());
        lootMap.clear();
        lootOverrideMap.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : resourceMap.entrySet()) {
            ResourceLocation resourceLocation = entry.getKey();
            LOGGER.debug("Processing resource: {}", (Object)resourceLocation);
            try {
                String path = resourceLocation.m_135815_();
                LOGGER.debug("Resource path: {}", (Object)path);
                String[] pathParts = path.split("/");
                if (pathParts.length != 2) {
                    LOGGER.warn("Invalid bestiary loot file path: {}", (Object)path);
                    continue;
                }
                String entityNamespace = pathParts[0];
                String entityPath = pathParts[1].replace(".json", "");
                ResourceLocation entityId = new ResourceLocation(entityNamespace, entityPath);
                LOGGER.debug("Extracted entity ID: {}", (Object)entityId);
                EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(entityId);
                if (entityType == null) {
                    LOGGER.warn("Unknown entity type: {}", (Object)entityId);
                    continue;
                }
                JsonObject jsonObject = entry.getValue().getAsJsonObject();
                boolean lootOverride = false;
                if (jsonObject.has("lootOverride") && jsonObject.get("lootOverride").isJsonPrimitive()) {
                    lootOverride = jsonObject.get("lootOverride").getAsBoolean();
                    LOGGER.debug("Found global loot override flag for entity {}: {}", (Object)entityId, (Object)lootOverride);
                    lootOverrideMap.put(entityType, lootOverride);
                }
                List<LootItemEntry> lootEntries = this.parseLootEntries(jsonObject, lootOverride);
                LOGGER.debug("Parsed {} loot entries for entity {}", (Object)lootEntries.size(), (Object)entityId);
                lootMap.put(entityType, lootEntries);
                LOGGER.debug("Added {} loot entries for entity {} to lootMap", (Object)lootEntries.size(), (Object)entityId);
            }
            catch (Exception e) {
                LOGGER.error("Error loading bestiary loot file {}: {}", new Object[]{resourceLocation, e.getMessage(), e});
            }
        }
        LOGGER.info("Loaded bestiary loot data for {} entities. LootMap size: {}", (Object)resourceMap.size(), (Object)lootMap.size());
        for (Map.Entry<Object, Object> entry : lootMap.entrySet()) {
            ResourceLocation entityId = ForgeRegistries.ENTITY_TYPES.getKey((Object)((EntityType)entry.getKey()));
            LOGGER.debug("LootMap contains entity {} with {} loot entries", (Object)entityId, (Object)((List)entry.getValue()).size());
        }
    }

    private List<LootItemEntry> parseLootEntries(JsonObject jsonObject, boolean globalOverride) throws JsonParseException {
        ArrayList<LootItemEntry> lootEntries = new ArrayList<LootItemEntry>();
        LOGGER.debug("Parsing loot entries from JSON: {}", (Object)jsonObject);
        if (!jsonObject.has("loot")) {
            LOGGER.debug("JSON object does not have 'loot' field; defaulting to empty loot list");
            return lootEntries;
        }
        if (!jsonObject.get("loot").isJsonArray()) {
            LOGGER.debug("'loot' field is not a JSON array; defaulting to empty loot list");
            return lootEntries;
        }
        JsonArray lootArray = jsonObject.getAsJsonArray("loot");
        LOGGER.debug("Loot array contains {} entries", (Object)lootArray.size());
        for (int i = 0; i < lootArray.size(); ++i) {
            ResourceLocation itemResourceLocation;
            Item item;
            JsonElement element = lootArray.get(i);
            LOGGER.debug("Processing loot entry {}: {}", (Object)i, (Object)element);
            if (!element.isJsonObject()) {
                LOGGER.debug("Loot entry {} is not a JSON object, skipping", (Object)i);
                continue;
            }
            JsonObject lootObject = element.getAsJsonObject();
            if (!lootObject.has("item")) {
                LOGGER.debug("Loot entry {} is missing 'item' field, skipping", (Object)i);
                continue;
            }
            if (!lootObject.get("item").isJsonPrimitive()) {
                LOGGER.debug("Loot entry {} 'item' field is not a primitive, skipping", (Object)i);
                continue;
            }
            String itemId = lootObject.get("item").getAsString();
            LOGGER.debug("Loot entry {} item ID: {}", (Object)i, (Object)itemId);
            MutableComponent displayName = Component.m_237119_();
            if (lootObject.has("displayNameKey") && lootObject.get("displayNameKey").isJsonPrimitive()) {
                String key = lootObject.get("displayNameKey").getAsString();
                if (!key.isEmpty()) {
                    displayName = Component.m_237115_((String)key);
                } else if (lootObject.has("displayName") && lootObject.get("displayName").isJsonPrimitive()) {
                    displayName = Component.m_237113_((String)lootObject.get("displayName").getAsString());
                    LOGGER.debug("Loot entry {} display name: {}", (Object)i, (Object)displayName);
                }
            } else if (lootObject.has("displayName") && lootObject.get("displayName").isJsonPrimitive()) {
                displayName = Component.m_237113_((String)lootObject.get("displayName").getAsString());
                LOGGER.debug("Loot entry {} display name: {}", (Object)i, (Object)displayName);
            }
            float dropChance = -1.0f;
            if (lootObject.has("dropChance") && lootObject.get("dropChance").isJsonPrimitive()) {
                dropChance = lootObject.get("dropChance").getAsFloat();
                LOGGER.debug("Loot entry {} drop chance: {}", (Object)i, (Object)Float.valueOf(dropChance));
            }
            boolean override = globalOverride;
            if (!globalOverride && lootObject.has("override") && lootObject.get("override").isJsonPrimitive()) {
                override = lootObject.get("override").getAsBoolean();
                LOGGER.debug("Loot entry {} override flag: {}", (Object)i, (Object)override);
            }
            if ((item = (Item)ForgeRegistries.ITEMS.getValue(itemResourceLocation = new ResourceLocation(itemId))) == null) {
                LOGGER.warn("Unknown item for loot entry {}: {}", (Object)i, (Object)itemId);
                continue;
            }
            ItemStack itemStack = new ItemStack((ItemLike)item);
            LootItemEntry lootEntry = new LootItemEntry(itemStack, (Component)displayName, dropChance, override);
            lootEntries.add(lootEntry);
            LOGGER.debug("Added loot entry {} to list: {} with chance {} and override {}", new Object[]{i, displayName, Float.valueOf(dropChance), override});
        }
        LOGGER.debug("Parsed {} loot entries from JSON", (Object)lootEntries.size());
        return lootEntries;
    }
}

