/*
 * Decompiled with CFR 0.152.
 */
package com.araxer.araxers_bestiary.data;

import com.araxer.araxers_bestiary.data.SpawnLocationInfo;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.slf4j.Logger;

@Mod.EventBusSubscriber(modid="araxers_bestiary")
public class BestiarySpawnLocationManager
extends SimpleJsonResourceReloadListener {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final String FOLDER_PATH = "bestiary";
    private static Map<EntityType<?>, SpawnLocationInfo> spawnLocationsMap = new HashMap();

    public BestiarySpawnLocationManager() {
        super(GSON, FOLDER_PATH);
    }

    @SubscribeEvent
    public static void onResourceReload(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new BestiarySpawnLocationManager());
        LOGGER.debug("Registered bestiary spawn location manager as resource reload listener");
    }

    public static SpawnLocationInfo getSpawnLocationsForEntity(EntityType<?> entityType) {
        return spawnLocationsMap.get(entityType);
    }

    public static boolean hasSpawnLocationsForEntity(EntityType<?> entityType) {
        return spawnLocationsMap.containsKey(entityType);
    }

    public static void updateSpawnLocationCache(EntityType<?> entityType, SpawnLocationInfo spawnLocationInfo) {
        if (spawnLocationInfo != null) {
            spawnLocationsMap.put(entityType, spawnLocationInfo);
            LOGGER.debug("Updated spawn location cache for {} with {} locations", (Object)entityType.m_20676_().getString(), (Object)spawnLocationInfo.getAllLocations().size());
        } else {
            LOGGER.warn("Attempted to update spawn location cache with null info for {}", (Object)entityType.m_20676_().getString());
        }
    }

    public static void clearCache() {
        spawnLocationsMap.clear();
        LOGGER.debug("BestiarySpawnLocationManager cache cleared.");
    }

    protected void apply(Map<ResourceLocation, JsonElement> resourceMap, ResourceManager resourceManager, ProfilerFiller profiler) {
        LOGGER.debug("Loading bestiary spawn location data from data packs");
        spawnLocationsMap.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : resourceMap.entrySet()) {
            ResourceLocation resourceLocation = entry.getKey();
            try {
                String path = resourceLocation.m_135815_();
                String[] pathParts = path.split("/");
                if (pathParts.length != 2) {
                    LOGGER.warn("Invalid bestiary file path: {}", (Object)path);
                    continue;
                }
                String entityNamespace = pathParts[0];
                String entityPath = pathParts[1].replace(".json", "");
                ResourceLocation entityId = new ResourceLocation(entityNamespace, entityPath);
                EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(entityId);
                if (entityType == null) {
                    LOGGER.warn("Unknown entity type: {}", (Object)entityId);
                    continue;
                }
                JsonObject jsonObject = entry.getValue().getAsJsonObject();
                SpawnLocationInfo spawnLocations = this.parseSpawnLocations(jsonObject);
                if (spawnLocations == null) continue;
                spawnLocationsMap.put(entityType, spawnLocations);
                LOGGER.debug("Loaded spawn locations for entity {}: {}", (Object)entityId, (Object)spawnLocations.getPrimaryLocation());
            }
            catch (Exception e) {
                LOGGER.error("Error loading bestiary file {}: {}", (Object)resourceLocation, (Object)e.getMessage());
            }
        }
        LOGGER.info("Loaded bestiary spawn location data for {} entities", (Object)spawnLocationsMap.size());
    }

    private SpawnLocationInfo parseSpawnLocations(JsonObject jsonObject) throws JsonParseException {
        if (!jsonObject.has("spawnLocations") || !jsonObject.get("spawnLocations").isJsonArray()) {
            return null;
        }
        JsonArray spawnLocationsArray = jsonObject.getAsJsonArray("spawnLocations");
        ArrayList<Component> spawnLocations = new ArrayList<Component>();
        boolean override = false;
        for (JsonElement element : spawnLocationsArray) {
            if (!element.isJsonPrimitive()) continue;
            spawnLocations.add((Component)Component.m_237113_((String)element.getAsString()));
        }
        if (spawnLocations.isEmpty()) {
            return null;
        }
        if (jsonObject.has("spawnLocationsOverride") && jsonObject.get("spawnLocationsOverride").isJsonPrimitive()) {
            override = jsonObject.get("spawnLocationsOverride").getAsBoolean();
            LOGGER.debug("Found override flag for spawn locations: {}", (Object)override);
        }
        return new SpawnLocationInfo(spawnLocations, override);
    }
}

