/*
 * Decompiled with CFR 0.152.
 */
package com.araxer.araxers_bestiary.data;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class SpawnLocationInfo {
    private final List<Component> spawnLocations;
    private final Component primaryLocation;
    private final boolean override;

    public SpawnLocationInfo(List<Component> spawnLocations, boolean override) {
        this.spawnLocations = new ArrayList<Component>(spawnLocations);
        this.primaryLocation = spawnLocations.isEmpty() ? Component.m_237113_((String)"Unknown") : spawnLocations.get(0);
        this.override = override;
    }

    public SpawnLocationInfo(List<Component> spawnLocations) {
        this(spawnLocations, false);
    }

    public SpawnLocationInfo(Component spawnLocation) {
        this.spawnLocations = new ArrayList<Component>();
        this.spawnLocations.add(spawnLocation);
        this.primaryLocation = spawnLocation;
        this.override = false;
    }

    public SpawnLocationInfo(Component spawnLocation, boolean override) {
        this.spawnLocations = new ArrayList<Component>();
        this.spawnLocations.add(spawnLocation);
        this.primaryLocation = spawnLocation;
        this.override = override;
    }

    public Component getPrimaryLocation() {
        return this.primaryLocation;
    }

    public List<Component> getAllLocations() {
        LinkedHashMap<String, Component> uniqueLocations = new LinkedHashMap<String, Component>();
        for (Component location : this.spawnLocations) {
            String key = location.getString();
            uniqueLocations.put(key, location);
        }
        return new ArrayList<Component>(uniqueLocations.values());
    }

    public boolean isOverride() {
        return this.override;
    }

    public boolean hasMultipleLocations() {
        return this.spawnLocations.size() > 1;
    }

    public Component getDisplayText() {
        if (this.hasMultipleLocations()) {
            return this.primaryLocation.m_6881_().m_130946_(" + ").m_130946_(String.valueOf(this.spawnLocations.size() - 1)).m_130946_(" more");
        }
        return this.primaryLocation;
    }

    public static SpawnLocationInfo fromBiomeKey(ResourceLocation biomeKey) {
        return SpawnLocationInfo.fromBiomeKey(biomeKey, false);
    }

    public static SpawnLocationInfo fromBiomeKey(ResourceLocation biomeKey, boolean override) {
        Component displayName = SpawnLocationInfo.getBiomeDisplayName(biomeKey);
        return new SpawnLocationInfo(displayName, override);
    }

    public static SpawnLocationInfo fromBiomeKeys(List<ResourceLocation> biomeKeys) {
        return SpawnLocationInfo.fromBiomeKeys(biomeKeys, false);
    }

    public static SpawnLocationInfo fromBiomeKeys(List<ResourceLocation> biomeKeys, boolean override) {
        List<Component> displayNames = biomeKeys.stream().map(biomeKey -> Component.m_237115_((String)("biome." + biomeKey.m_214298_()))).collect(Collectors.toList());
        return new SpawnLocationInfo(displayNames, override);
    }

    private static Component getBiomeDisplayName(ResourceLocation biomeKey) {
        return Component.m_237115_((String)("biome." + biomeKey.m_214298_()));
    }
}

