/*
 * Decompiled with CFR 0.152.
 */
package com.envygames.dimensionalpha.block;

import com.envygames.dimensionalpha.blockentity.TeleporterBlockEntity;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DimensionAlphaTeleporterBlock
extends Block
implements EntityBlock {
    private static final Logger LOGGER = LogManager.getLogger((String)"Dimensionalpha");

    public DimensionAlphaTeleporterBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new TeleporterBlockEntity(pos, state);
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState state) {
        return RenderShape.MODEL;
    }

    public void onRemove(BlockState oldState, @NotNull Level world, @NotNull BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity be;
        if (!oldState.is(newState.getBlock()) && (be = world.getBlockEntity(pos)) instanceof TeleporterBlockEntity) {
            TeleporterBlockEntity tbe = (TeleporterBlockEntity)be;
            ResourceKey<Level> partnerDim = tbe.linkedDimension();
            BlockPos partnerPos = tbe.linkedPosition();
            LOGGER.info("Teleporter broken at {} in {}, clearing its link to {} at {}", (Object)pos, (Object)world.dimension(), partnerDim, (Object)partnerPos);
            tbe.clearLink();
            if (partnerDim != null && partnerPos != null) {
                ServerLevel dest = Objects.requireNonNull(world.getServer()).getLevel(partnerDim);
                if (dest != null) {
                    BlockEntity partnerBE = dest.getBlockEntity(partnerPos);
                    if (partnerBE instanceof TeleporterBlockEntity) {
                        TeleporterBlockEntity ptbe = (TeleporterBlockEntity)partnerBE;
                        LOGGER.info("Clearing link on partner teleporter at {} in {}", (Object)partnerPos, partnerDim);
                        ptbe.clearLink();
                    } else {
                        LOGGER.warn("No teleporter BE found at partner pos {} in {}", (Object)partnerPos, partnerDim);
                    }
                    dest.setBlockAndUpdate(partnerPos, Blocks.AIR.defaultBlockState());
                    LOGGER.info("Removed partner teleporter block at {} in {}", (Object)partnerPos, partnerDim);
                } else {
                    LOGGER.warn("Could not load partner dimension {}", partnerDim);
                }
            }
        }
        super.onRemove(oldState, world, pos, newState, isMoving);
    }
}

